/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.dialogs.panels.confirm;

import de.alpharogroup.locale.ResourceBundleKey;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;

public abstract class YesNoPanel<T>
extends GenericPanel<T> {
    private static final long serialVersionUID = 1L;
    private final Label label;
    private final AjaxButton noButton;
    private final AjaxButton yesButton;

    public YesNoPanel(String id, IModel<T> model, IModel<String> labelModel) {
        super(id, model);
        Component[] componentArray = new Component[1];
        this.label = this.newLabel("message", labelModel);
        componentArray[0] = this.label;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.yesButton = this.newYesButton("yesButton");
        componentArray2[0] = this.yesButton;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.noButton = this.newNoButton("noButton");
        componentArray3[0] = this.noButton;
        this.add(componentArray3);
    }

    protected Label newLabel(String id, IModel<String> model) {
        return ComponentFactory.newLabel((String)id, model);
    }

    protected AjaxButton newNoButton(String id) {
        AjaxButton ajaxButton = new AjaxButton(id){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                YesNoPanel.this.onNo(target, form, true);
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                YesNoPanel.this.onNo(target, form, false);
            }
        };
        IModel noLabelModel = ResourceModelFactory.newResourceModel((ResourceBundleKey)ResourceBundleKey.builder().key("global.no.label").defaultValue("No").build(), (Component)this);
        ajaxButton.add(new Component[]{this.newLabel("noLabel", (IModel<String>)noLabelModel)});
        return ajaxButton;
    }

    protected AjaxButton newYesButton(String id) {
        AjaxButton ajaxButton = new AjaxButton(id){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                YesNoPanel.this.onYes(target, form, true);
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                YesNoPanel.this.onYes(target, form, false);
            }
        };
        IModel yesLabelModel = ResourceModelFactory.newResourceModel((ResourceBundleKey)ResourceBundleKey.builder().key("global.yes.label").defaultValue("Yes").build(), (Component)this);
        ajaxButton.add(new Component[]{this.newLabel("yesLabel", (IModel<String>)yesLabelModel)});
        return ajaxButton;
    }

    public abstract void onNo(AjaxRequestTarget var1, Form<?> var2, boolean var3);

    public abstract void onYes(AjaxRequestTarget var1, Form<?> var2, boolean var3);

    public Label getLabel() {
        return this.label;
    }

    public AjaxButton getNoButton() {
        return this.noButton;
    }

    public AjaxButton getYesButton() {
        return this.yesButton;
    }
}

