/*
 * Decompiled with CFR 0.152.
 */
package org.jaulp.wicket.dialogs.panels.save;

import de.alpharogroup.wicket.components.factory.ComponentFactory;
import net.sourceforge.jaulp.locale.ResourceBundleKey;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.jaulp.wicket.base.BasePanel;

public class SaveDialogPanel<T>
extends BasePanel<T> {
    private static final long serialVersionUID = 1L;
    private final Label descriptionLabel;
    private final Label cancelLabel;
    private final Label saveLabel;
    private final AjaxButton cancelButton;
    private final AjaxButton saveButton;
    private final Component textFieldLabel;
    private final Form<?> form;
    private final Component textField;

    public SaveDialogPanel(String id, IModel<T> model) {
        super(id, model);
        this.setOutputMarkupId(true);
        Component[] componentArray = new Component[1];
        this.form = this.newForm("form", model);
        componentArray[0] = this.form;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.descriptionLabel = this.newDescriptionLabel("descriptionLabel", ResourceBundleKey.builder().key("save.description.label").build());
        componentArray2[0] = this.descriptionLabel;
        this.form.add(componentArray2);
        this.textFieldLabel = this.newTextFieldLabel("textFieldLabel", ResourceBundleKey.builder().key("main.global.form.textfield.label").build());
        this.form.add(new Component[]{this.textFieldLabel});
        this.textField = this.newTextField("textField", model);
        this.form.add(new Component[]{this.textField});
        Component[] componentArray3 = new Component[1];
        this.cancelButton = this.newCancelButton("cancelButton", this.form);
        componentArray3[0] = this.cancelButton;
        this.form.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.cancelLabel = this.newCancelLabel("cancelLabel", ResourceBundleKey.builder().key("main.global.cancel.button.label").defaultValue("Cancel").build());
        componentArray4[0] = this.cancelLabel;
        this.cancelButton.add(componentArray4);
        Component[] componentArray5 = new Component[1];
        this.saveButton = this.newSaveButton("saveButton", this.form);
        componentArray5[0] = this.saveButton;
        this.form.add(componentArray5);
        Component[] componentArray6 = new Component[1];
        this.saveLabel = this.newSaveLabel("saveLabel", ResourceBundleKey.builder().key("main.global.save.button.label").defaultValue("Save").build());
        componentArray6[0] = this.saveLabel;
        this.saveButton.add(componentArray6);
    }

    protected Component newTextFieldLabel(String id, ResourceBundleKey resourceKey) {
        return ComponentFactory.newLabel((String)id, (ResourceBundleKey)resourceKey, (Component)this);
    }

    protected Component newTextField(String id, IModel<T> model) {
        return ComponentFactory.newTextField((String)id, model);
    }

    protected Form<?> newForm(String id, IModel<T> model) {
        return ComponentFactory.newForm((String)id, model);
    }

    protected AjaxButton newSaveButton(String id, Form<?> form) {
        AjaxButton saveButton = new AjaxButton(id, form){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                SaveDialogPanel.this.onSave(target, form);
            }
        };
        return saveButton;
    }

    protected AjaxButton newCancelButton(String id, Form<?> form) {
        AjaxButton cancelButton = new AjaxButton(id, form){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                SaveDialogPanel.this.onCancel(target, form);
            }
        };
        return cancelButton;
    }

    protected Label newDescriptionLabel(String id, ResourceBundleKey resourceKey) {
        return ComponentFactory.newLabel((String)id, (ResourceBundleKey)resourceKey, (Component)this);
    }

    protected Label newSaveLabel(String id, ResourceBundleKey resourceKey) {
        return ComponentFactory.newLabel((String)id, (ResourceBundleKey)resourceKey, (Component)this);
    }

    protected Label newCancelLabel(String id, ResourceBundleKey resourceKey) {
        return ComponentFactory.newLabel((String)id, (ResourceBundleKey)resourceKey, (Component)this);
    }

    protected void onCancel(AjaxRequestTarget target, Form<?> form) {
        target.add(new Component[]{form});
    }

    protected void onSave(AjaxRequestTarget target, Form<?> form) {
        target.add(new Component[]{form});
    }

    public Label getDescriptionLabel() {
        return this.descriptionLabel;
    }

    public Label getCancelLabel() {
        return this.cancelLabel;
    }

    public Label getSaveLabel() {
        return this.saveLabel;
    }

    public AjaxButton getCancelButton() {
        return this.cancelButton;
    }

    public AjaxButton getSaveButton() {
        return this.saveButton;
    }

    public Component getTextFieldLabel() {
        return this.textFieldLabel;
    }

    public Form<?> getForm() {
        return this.form;
    }

    public Component getTextField() {
        return this.textField;
    }
}

