/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.sign.in;

import de.alpharogroup.auth.models.SignInModel;
import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.components.labeled.textfield.LabeledEmailTextFieldPanel;
import de.alpharogroup.wicket.components.labeled.textfield.LabeledPasswordTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.EmailTextField;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SigninPanel<T extends SignInModel>
extends BasePanel<T> {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(SigninPanel.class);
    private final Component email;
    private final Component password;

    public SigninPanel(String id, IModel<T> model) {
        super(id, model);
        this.email = this.newEmailTextField("email", model);
        this.add(new Component[]{this.email});
        this.password = this.newPasswordTextField("password", model);
        this.add(new Component[]{this.password});
    }

    protected Component newEmailTextField(String id, final IModel<T> model) {
        IModel labelModel = ResourceModelFactory.newResourceModel((String)"global.email.label", (Component)this);
        final IModel placeholderModel = ResourceModelFactory.newResourceModel((String)"global.enter.your.email.label", (Component)this);
        LabeledEmailTextFieldPanel emailTextField = new LabeledEmailTextFieldPanel<T>(id, model, labelModel){
            private static final long serialVersionUID = 1L;

            @Override
            protected EmailTextField newEmailTextField(String id, IModel<T> m) {
                EmailTextField emailTextField = new EmailTextField(id, (IModel)new PropertyModel((Object)model, "email"));
                emailTextField.setOutputMarkupId(true);
                emailTextField.setRequired(true);
                if (placeholderModel != null) {
                    emailTextField.add(new Behavior[]{new AttributeAppender("placeholder", placeholderModel)});
                }
                return emailTextField;
            }
        };
        return emailTextField;
    }

    protected Component newPasswordTextField(String id, IModel<T> model) {
        IModel labelModel = ResourceModelFactory.newResourceModel((String)"global.password.label", (Component)this);
        final IModel placeholderModel = ResourceModelFactory.newResourceModel((String)"global.enter.your.password.label", (Component)this);
        LabeledPasswordTextFieldPanel pwTextField = new LabeledPasswordTextFieldPanel<T>(id, model, labelModel){
            private static final long serialVersionUID = 1L;

            @Override
            protected PasswordTextField newPasswordTextField(String id, IModel<T> model) {
                PasswordTextField pwTextField = new PasswordTextField(id, (IModel)new PropertyModel(model, "password"));
                pwTextField.setOutputMarkupId(true);
                if (placeholderModel != null) {
                    pwTextField.add(new Behavior[]{new AttributeAppender("placeholder", placeholderModel)});
                }
                return pwTextField;
            }
        };
        return pwTextField;
    }

    public Component getEmail() {
        return this.email;
    }

    public Component getPassword() {
        return this.password;
    }
}

