/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.factory;

import de.alpharogroup.locale.ResourceBundleKey;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.yui.calendar.DateTimeField;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.EnumLabel;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.CheckGroupSelector;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.EmailTextField;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.ComponentFeedbackPanel;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.IResource;

public class ComponentFactory {
    public static CheckBox newCheckBox(String id, IModel<Boolean> model) {
        CheckBox checkBox = new CheckBox(id, model);
        checkBox.setOutputMarkupId(true);
        return checkBox;
    }

    public static <T> CheckGroup<T> newCheckGroup(String id, IModel<? extends Collection<T>> model) {
        CheckGroup checkGroup = new CheckGroup(id, model);
        checkGroup.setOutputMarkupId(true);
        return checkGroup;
    }

    public static <T> CheckGroupSelector newCheckGroupSelector(String id) {
        CheckGroupSelector checkGroupSelector = new CheckGroupSelector(id);
        checkGroupSelector.setOutputMarkupId(true);
        return checkGroupSelector;
    }

    public static <T> CheckGroupSelector newCheckGroupSelector(String id, CheckGroup<T> group) {
        CheckGroupSelector checkGroupSelector = new CheckGroupSelector(id, group);
        checkGroupSelector.setOutputMarkupId(true);
        return checkGroupSelector;
    }

    public static ComponentFeedbackPanel newComponentFeedbackPanel(String id, Component filter) {
        ComponentFeedbackPanel feedbackPanel = new ComponentFeedbackPanel(id, filter);
        feedbackPanel.setOutputMarkupId(true);
        return feedbackPanel;
    }

    public static DateTimeField newDateTimeField(String id, IModel<Date> model) {
        DateTimeField dateTextField = new DateTimeField(id, model);
        dateTextField.setOutputMarkupId(true);
        return dateTextField;
    }

    public static <T> DropDownChoice<T> newDropDownChoice(String id, IModel<T> model, List<? extends T> choices) {
        DropDownChoice dropDownChoice = new DropDownChoice(id, model, choices);
        dropDownChoice.setOutputMarkupId(true);
        return dropDownChoice;
    }

    public static <T> DropDownChoice<T> newDropDownChoice(String id, IModel<T> model, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        DropDownChoice dropDownChoice = new DropDownChoice(id, model, choices, renderer);
        dropDownChoice.setOutputMarkupId(true);
        return dropDownChoice;
    }

    public static EmailTextField newEmailTextField(String id, IModel<String> model) {
        EmailTextField emailTextField = new EmailTextField(id, model);
        emailTextField.setOutputMarkupId(true);
        return emailTextField;
    }

    public static <T extends Enum<T>> EnumLabel<T> newEnumLabel(String id, IModel<T> model) {
        EnumLabel enumLabel = new EnumLabel<T>(id, model){
            private static final long serialVersionUID = 1L;

            protected String resourceKey(T value) {
                return ((Enum)value).name();
            }
        };
        enumLabel.setOutputMarkupId(true);
        return enumLabel;
    }

    public static FeedbackPanel newFeedbackPanel(String id) {
        FeedbackPanel feedbackPanel = new FeedbackPanel(id);
        feedbackPanel.setOutputMarkupId(true);
        return feedbackPanel;
    }

    public static <T> Form<T> newForm(String id) {
        return ComponentFactory.newForm(id, null);
    }

    public static <T> Form<T> newForm(String id, IModel<T> model) {
        Form form = new Form(id, model);
        form.setOutputMarkupId(true);
        return form;
    }

    public static Fragment newFragment(String id, String markupId, MarkupContainer markupProvider) {
        return ComponentFactory.newFragment(id, markupId, markupProvider, null);
    }

    public static <T> Fragment newFragment(String id, String markupId, MarkupContainer markupProvider, IModel<T> model) {
        Fragment fragment = new Fragment(id, markupId, markupProvider, model);
        fragment.setOutputMarkupId(true);
        return fragment;
    }

    public static Component newHiddenField(String id) {
        HiddenField hiddenField = new HiddenField(id);
        hiddenField.setOutputMarkupId(true);
        return hiddenField;
    }

    public static Image newImage(String id, IResource imageResource) {
        Image image = new Image(id, imageResource);
        image.setOutputMarkupId(true);
        return image;
    }

    public static <T> Label newLabel(String id, IModel<T> model) {
        Label label = new Label(id, model);
        label.setOutputMarkupId(true);
        return label;
    }

    public static Label newLabel(String id, ResourceBundleKey resourceKey, Component component) {
        return ComponentFactory.newLabel(id, ResourceModelFactory.newResourceModel((ResourceBundleKey)resourceKey, (Component)component));
    }

    public static Label newLabel(String id, String label) {
        return ComponentFactory.newLabel(id, Model.of((Serializable)((Object)label)));
    }

    public static <T> Label newLabel(String id, String forId, IModel<T> model) {
        Label label = new Label(id, model);
        label.add(new Behavior[]{new AttributeAppender("for", (IModel)Model.of((Serializable)((Object)forId)), " ")});
        label.setOutputMarkupId(true);
        return label;
    }

    public static Label newLabel(String id, String forId, ResourceBundleKey resourceBundleKey, Component component) {
        return ComponentFactory.newLabel(id, forId, ResourceModelFactory.newResourceModel((ResourceBundleKey)resourceBundleKey, (Component)component));
    }

    public static Label newLabel(String id, String resourceKey, String defaultValue, Component component) {
        return ComponentFactory.newLabel(id, ResourceModelFactory.newResourceModel((String)resourceKey, (Component)component, (String)defaultValue));
    }

    public static <T> MultiLineLabel newMultiLineLabel(String id, IModel<T> model) {
        MultiLineLabel multiLineLabel = new MultiLineLabel(id, model);
        multiLineLabel.setOutputMarkupId(true);
        return multiLineLabel;
    }

    public static PasswordTextField newPasswordTextField(String id, IModel<String> model) {
        PasswordTextField passwordTextField = new PasswordTextField(id, model);
        passwordTextField.setOutputMarkupId(true);
        return passwordTextField;
    }

    public static <T> RadioChoice<T> newRadioChoice(String id, IModel<T> model, List<? extends T> choices) {
        RadioChoice radioChoice = new RadioChoice(id, model, choices);
        radioChoice.setOutputMarkupId(true);
        return radioChoice;
    }

    public static <T> RadioChoice<T> newRadioChoice(String id, IModel<T> model, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        RadioChoice radioChoice = new RadioChoice(id, model, choices, renderer);
        radioChoice.setOutputMarkupId(true);
        return radioChoice;
    }

    public static <T> RadioGroup<T> newRadioGroup(String id) {
        return ComponentFactory.newRadioGroup(id, null);
    }

    public static <T> RadioGroup<T> newRadioGroup(String id, IModel<T> model) {
        RadioGroup radioGroup = new RadioGroup(id, model);
        radioGroup.setOutputMarkupId(true);
        return radioGroup;
    }

    public static <T> RequiredTextField<T> newRequiredTextField(String id, IModel<T> model) {
        RequiredTextField requiredTextField = new RequiredTextField(id, model);
        requiredTextField.setOutputMarkupId(true);
        return requiredTextField;
    }

    public static <T> TextArea<T> newTextArea(String id, IModel<T> model) {
        TextArea textArea = new TextArea(id, model);
        textArea.setOutputMarkupId(true);
        return textArea;
    }

    public static <T> TextField<T> newTextField(String id) {
        return ComponentFactory.newTextField(id, null);
    }

    public static <T> TextField<T> newTextField(String id, IModel<T> model) {
        TextField textField = new TextField(id, model);
        textField.setOutputMarkupId(true);
        return textField;
    }

    public static WebMarkupContainer newWebMarkupContainer(String id) {
        return ComponentFactory.newWebMarkupContainer(id, null);
    }

    public static <T> WebMarkupContainer newWebMarkupContainer(String id, IModel<T> model) {
        WebMarkupContainer webMarkupContainer = new WebMarkupContainer(id, model);
        webMarkupContainer.setOutputMarkupId(true);
        return webMarkupContainer;
    }
}

