/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.download;

import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.base.util.application.ApplicationExtensions;
import de.alpharogroup.wicket.behaviors.AjaxDownloadBehavior;
import de.alpharogroup.wicket.components.download.DownloadModelBean;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import java.io.IOException;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.IResourceStream;

public abstract class DownloadPanel
extends BasePanel<DownloadModelBean> {
    private static final long serialVersionUID = 1L;
    private Component fileNameLabel;
    private AjaxLink<Void> downloadLink;

    public DownloadPanel(String id, IModel<DownloadModelBean> model) {
        super(id, model);
        Args.notNull(model, (String)"model");
    }

    protected abstract WebApplication getWebApplication();

    protected AjaxLink<Void> newDownloadLink(String id, final IModel<DownloadModelBean> model) {
        final AjaxDownloadBehavior download = new AjaxDownloadBehavior(){
            private static final long serialVersionUID = 1L;

            protected String getFileName() {
                return ((DownloadModelBean)model.getObject()).getFilename();
            }

            protected IResourceStream getResourceStream() {
                try {
                    return ApplicationExtensions.getResourceStream((WebApplication)DownloadPanel.this.getWebApplication(), (String)((DownloadModelBean)model.getObject()).getPath(), (String)((DownloadModelBean)model.getObject()).getContentType());
                }
                catch (IOException e) {
                    DownloadPanel.this.getSession().info((Serializable)((Object)("Error: " + e.getLocalizedMessage())));
                    return null;
                }
            }
        };
        AjaxLink<Void> downloadLink = new AjaxLink<Void>(id){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                download.initiate(target);
            }
        };
        downloadLink.add(new Behavior[]{download});
        return downloadLink;
    }

    protected Component newFileNameLabel(String id, IModel<String> model) {
        return ComponentFactory.newLabel(id, model);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.fileNameLabel = this.newFileNameLabel("fileName", (IModel<String>)new PropertyModel(this.getModelObject(), "filename"));
        this.downloadLink = this.newDownloadLink("downloadLink", (IModel<DownloadModelBean>)this.getModel());
        this.downloadLink.addOrReplace(new Component[]{this.fileNameLabel});
        this.addOrReplace(new Component[]{this.downloadLink});
    }

    public Component getFileNameLabel() {
        return this.fileNameLabel;
    }

    public AjaxLink<Void> getDownloadLink() {
        return this.downloadLink;
    }
}

