/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.link;

import de.alpharogroup.locale.ResourceBundleKey;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;

public class LinkItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Class<? extends Page> pageClass;
    private Class<? extends Component> linkClass;
    @NonNull
    private ResourceBundleKey resourceModelKey;
    private String url;
    private String target;
    private Map<String, String> parameters;
    private List<LinkItem> children;
    private List<Behavior> behaviors;

    public static LinkItemBuilder builder() {
        return new LinkItemBuilder();
    }

    public Class<? extends Page> getPageClass() {
        return this.pageClass;
    }

    public Class<? extends Component> getLinkClass() {
        return this.linkClass;
    }

    @NonNull
    public ResourceBundleKey getResourceModelKey() {
        return this.resourceModelKey;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTarget() {
        return this.target;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public List<LinkItem> getChildren() {
        return this.children;
    }

    public List<Behavior> getBehaviors() {
        return this.behaviors;
    }

    public void setPageClass(Class<? extends Page> pageClass) {
        this.pageClass = pageClass;
    }

    public void setLinkClass(Class<? extends Component> linkClass) {
        this.linkClass = linkClass;
    }

    public void setResourceModelKey(@NonNull ResourceBundleKey resourceModelKey) {
        if (resourceModelKey == null) {
            throw new NullPointerException("resourceModelKey");
        }
        this.resourceModelKey = resourceModelKey;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setChildren(List<LinkItem> children) {
        this.children = children;
    }

    public void setBehaviors(List<Behavior> behaviors) {
        this.behaviors = behaviors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkItem)) {
            return false;
        }
        LinkItem other = (LinkItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<? extends Page> this$pageClass = this.getPageClass();
        Class<? extends Page> other$pageClass = other.getPageClass();
        if (this$pageClass == null ? other$pageClass != null : !this$pageClass.equals(other$pageClass)) {
            return false;
        }
        Class<? extends Component> this$linkClass = this.getLinkClass();
        Class<? extends Component> other$linkClass = other.getLinkClass();
        if (this$linkClass == null ? other$linkClass != null : !this$linkClass.equals(other$linkClass)) {
            return false;
        }
        ResourceBundleKey this$resourceModelKey = this.getResourceModelKey();
        ResourceBundleKey other$resourceModelKey = other.getResourceModelKey();
        if (this$resourceModelKey == null ? other$resourceModelKey != null : !this$resourceModelKey.equals(other$resourceModelKey)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        List<LinkItem> this$children = this.getChildren();
        List<LinkItem> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        List<Behavior> this$behaviors = this.getBehaviors();
        List<Behavior> other$behaviors = other.getBehaviors();
        return !(this$behaviors == null ? other$behaviors != null : !((Object)this$behaviors).equals(other$behaviors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LinkItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<? extends Page> $pageClass = this.getPageClass();
        result = result * 59 + ($pageClass == null ? 43 : $pageClass.hashCode());
        Class<? extends Component> $linkClass = this.getLinkClass();
        result = result * 59 + ($linkClass == null ? 43 : $linkClass.hashCode());
        ResourceBundleKey $resourceModelKey = this.getResourceModelKey();
        result = result * 59 + ($resourceModelKey == null ? 43 : $resourceModelKey.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        List<LinkItem> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        List<Behavior> $behaviors = this.getBehaviors();
        result = result * 59 + ($behaviors == null ? 43 : ((Object)$behaviors).hashCode());
        return result;
    }

    public String toString() {
        return "LinkItem(pageClass=" + this.getPageClass() + ", linkClass=" + this.getLinkClass() + ", resourceModelKey=" + this.getResourceModelKey() + ", url=" + this.getUrl() + ", target=" + this.getTarget() + ", parameters=" + this.getParameters() + ", children=" + this.getChildren() + ", behaviors=" + this.getBehaviors() + ")";
    }

    public LinkItem() {
    }

    @ConstructorProperties(value={"pageClass", "linkClass", "resourceModelKey", "url", "target", "parameters", "children", "behaviors"})
    public LinkItem(Class<? extends Page> pageClass, Class<? extends Component> linkClass, @NonNull ResourceBundleKey resourceModelKey, String url, String target, Map<String, String> parameters, List<LinkItem> children, List<Behavior> behaviors) {
        if (resourceModelKey == null) {
            throw new NullPointerException("resourceModelKey");
        }
        this.pageClass = pageClass;
        this.linkClass = linkClass;
        this.resourceModelKey = resourceModelKey;
        this.url = url;
        this.target = target;
        this.parameters = parameters;
        this.children = children;
        this.behaviors = behaviors;
    }

    public static class LinkItemBuilder {
        private Class<? extends Page> pageClass;
        private Class<? extends Component> linkClass;
        private ResourceBundleKey resourceModelKey;
        private String url;
        private String target;
        private ArrayList<String> parameters$key;
        private ArrayList<String> parameters$value;
        private ArrayList<LinkItem> children;
        private ArrayList<Behavior> behaviors;

        LinkItemBuilder() {
        }

        public LinkItemBuilder pageClass(Class<? extends Page> pageClass) {
            this.pageClass = pageClass;
            return this;
        }

        public LinkItemBuilder linkClass(Class<? extends Component> linkClass) {
            this.linkClass = linkClass;
            return this;
        }

        public LinkItemBuilder resourceModelKey(ResourceBundleKey resourceModelKey) {
            this.resourceModelKey = resourceModelKey;
            return this;
        }

        public LinkItemBuilder url(String url) {
            this.url = url;
            return this;
        }

        public LinkItemBuilder target(String target) {
            this.target = target;
            return this;
        }

        public LinkItemBuilder parameter(String parameterKey, String parameterValue) {
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            this.parameters$key.add(parameterKey);
            this.parameters$value.add(parameterValue);
            return this;
        }

        public LinkItemBuilder parameters(Map<? extends String, ? extends String> parameters) {
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : parameters.entrySet()) {
                this.parameters$key.add($lombokEntry.getKey());
                this.parameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public LinkItemBuilder child(LinkItem child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
            return this;
        }

        public LinkItemBuilder children(Collection<? extends LinkItem> children) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.addAll(children);
            return this;
        }

        public LinkItemBuilder behavior(Behavior behavior) {
            if (this.behaviors == null) {
                this.behaviors = new ArrayList();
            }
            this.behaviors.add(behavior);
            return this;
        }

        public LinkItemBuilder behaviors(Collection<? extends Behavior> behaviors) {
            if (this.behaviors == null) {
                this.behaviors = new ArrayList();
            }
            this.behaviors.addAll(behaviors);
            return this;
        }

        public LinkItem build() {
            List<Behavior> behaviors;
            List<LinkItem> children;
            Map<Object, Object> parameters;
            switch (this.parameters$key == null ? 0 : this.parameters$key.size()) {
                case 0: {
                    parameters = Collections.emptyMap();
                    break;
                }
                case 1: {
                    parameters = Collections.singletonMap(this.parameters$key.get(0), this.parameters$value.get(0));
                    break;
                }
                default: {
                    parameters = new LinkedHashMap(this.parameters$key.size() < 0x40000000 ? 1 + this.parameters$key.size() + (this.parameters$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.parameters$key.size(); ++$i) {
                        parameters.put(this.parameters$key.get($i), this.parameters$value.get($i));
                    }
                    parameters = Collections.unmodifiableMap(parameters);
                }
            }
            switch (this.children == null ? 0 : this.children.size()) {
                case 0: {
                    children = Collections.emptyList();
                    break;
                }
                case 1: {
                    children = Collections.singletonList(this.children.get(0));
                    break;
                }
                default: {
                    children = Collections.unmodifiableList(new ArrayList<LinkItem>(this.children));
                }
            }
            switch (this.behaviors == null ? 0 : this.behaviors.size()) {
                case 0: {
                    behaviors = Collections.emptyList();
                    break;
                }
                case 1: {
                    behaviors = Collections.singletonList(this.behaviors.get(0));
                    break;
                }
                default: {
                    behaviors = Collections.unmodifiableList(new ArrayList<Behavior>(this.behaviors));
                }
            }
            return new LinkItem(this.pageClass, this.linkClass, this.resourceModelKey, this.url, this.target, parameters, children, behaviors);
        }

        public String toString() {
            return "LinkItem.LinkItemBuilder(pageClass=" + this.pageClass + ", linkClass=" + this.linkClass + ", resourceModelKey=" + this.resourceModelKey + ", url=" + this.url + ", target=" + this.target + ", parameters$key=" + this.parameters$key + ", parameters$value=" + this.parameters$value + ", children=" + this.children + ", behaviors=" + this.behaviors + ")";
        }
    }
}

