/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.sign.in.form;

import de.alpharogroup.auth.models.SignInModel;
import de.alpharogroup.locale.ResourceBundleKey;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.link.LinkPanel;
import de.alpharogroup.wicket.components.sign.in.SigninPanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;

public abstract class SigninFormPanel<T extends SignInModel>
extends GenericPanel<T> {
    private static final long serialVersionUID = 1L;
    private final Label buttonLabel;
    private final Form<?> form;
    private final Component signinPanel;
    private final Button submitButton;
    private final MarkupContainer passwordForgottenLink;

    public SigninFormPanel(String id, IModel<T> model) {
        super(id, model);
        Component[] componentArray = new Component[1];
        this.form = this.newForm("form", model);
        componentArray[0] = this.form;
        this.add(componentArray);
        this.signinPanel = this.newSigninPanel("signinPanel", model);
        this.form.add(new Component[]{this.signinPanel});
        this.submitButton = this.newButton("submitButton");
        Component[] componentArray2 = new Component[1];
        this.buttonLabel = this.newButtonLabel("buttonLabel", "global.button.sign.in.label", "Sign In");
        componentArray2[0] = this.buttonLabel;
        this.submitButton.add(componentArray2);
        this.form.add(new Component[]{this.submitButton});
        this.passwordForgottenLink = this.newPasswordForgottenLink("passwordForgottenLink", model);
        this.add(new Component[]{this.passwordForgottenLink});
    }

    protected MarkupContainer newPasswordForgottenLink(String id, IModel<T> model) {
        LinkPanel linkPanel = new LinkPanel(id, ResourceModelFactory.newResourceModel((ResourceBundleKey)ResourceBundleKey.builder().key("password.forgotten.label").defaultValue("Password forgotten").build())){
            private static final long serialVersionUID = 1L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                SigninFormPanel.this.onPasswordForgotten(target, SigninFormPanel.this.form);
            }
        };
        return linkPanel;
    }

    protected Button newButton(String id) {
        return new AjaxButton(id){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                SigninFormPanel.this.onSignin(target, this.getForm());
            }
        };
    }

    protected Label newButtonLabel(String id, String resourceKey, String defaultValue) {
        IModel labelModel = ResourceModelFactory.newResourceModel((String)resourceKey, (Component)this, (String)defaultValue);
        return ComponentFactory.newLabel(id, labelModel);
    }

    protected Form<?> newForm(String id, IModel<?> model) {
        return ComponentFactory.newForm(id, model);
    }

    protected Component newSigninPanel(String id, IModel<? extends SignInModel> model) {
        SigninPanel component = new SigninPanel(id, model);
        return component;
    }

    protected abstract void onSignin(AjaxRequestTarget var1, Form<?> var2);

    protected abstract void onPasswordForgotten(AjaxRequestTarget var1, Form<?> var2);

    public Label getButtonLabel() {
        return this.buttonLabel;
    }

    public Form<?> getForm() {
        return this.form;
    }

    public Component getSigninPanel() {
        return this.signinPanel;
    }

    public Button getSubmitButton() {
        return this.submitButton;
    }

    public MarkupContainer getPasswordForgottenLink() {
        return this.passwordForgottenLink;
    }
}

