/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.report;

import de.alpharogroup.exception.ExceptionUtils;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.labeled.textarea.LabeledTextAreaPanel;
import de.alpharogroup.wicket.components.report.ReportThrowableModel;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.util.lang.Args;

public abstract class ReportThrowablePanel
extends GenericPanel<Throwable> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger((String)ReportThrowablePanel.class.getName());
    private final Label header;
    private final Form<?> form;
    private final LabeledTextAreaPanel<ReportThrowableModel> description;
    private final Button submitButton;
    private final Component stackTrace;
    private final ReportThrowableModel reportThrowableModel = this.newReportThrowableModel((Throwable)this.getModelObject());

    public ReportThrowablePanel(String id, Throwable throwable) {
        super(id, (IModel)Model.of((Serializable)((Serializable)Args.notNull((Object)throwable, (String)"throwable"))));
        CompoundPropertyModel cpm = new CompoundPropertyModel((Object)this.reportThrowableModel);
        this.setDefaultModel((IModel)cpm);
        Component[] componentArray = new Component[1];
        this.header = this.newHeaderLabel("header", (IModel<String>)ResourceModelFactory.newResourceModel((String)"header.label", (Component)this, (String)"Upps! An error occured."));
        componentArray[0] = this.header;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.form = this.newForm("form", (IModel<?>)cpm);
        componentArray2[0] = this.form;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.description = this.newDescription("description", (IModel<ReportThrowableModel>)cpm);
        componentArray3[0] = this.description;
        this.form.add(componentArray3);
        final MultiLineLabel toReplace = new MultiLineLabel("toReplace", (IModel)Model.of((Serializable)((Object)"")));
        toReplace.setOutputMarkupId(true);
        this.form.add(new Component[]{toReplace});
        AjaxLink<Void> link = new AjaxLink<Void>("link"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                toReplace.setDefaultModelObject((Object)ReportThrowablePanel.this.reportThrowableModel.getStackTrace());
                Effects.replace(target, (Component)toReplace);
            }
        };
        this.form.add(new Component[]{link});
        Component[] componentArray4 = new Component[1];
        this.submitButton = this.newSubmitButton("submitButton");
        componentArray4[0] = this.submitButton;
        this.form.add(componentArray4);
        this.stackTrace = this.newHiddenField("stackTrace");
        this.form.add(new Component[]{this.stackTrace});
        LOGGER.error((Object)this.reportThrowableModel.getStackTrace());
    }

    protected Component newHiddenField(String id) {
        return ComponentFactory.newHiddenField(id);
    }

    protected Label newHeaderLabel(String id, IModel<String> model) {
        return ComponentFactory.newLabel(id, model);
    }

    protected Form<?> newForm(String id, IModel<?> model) {
        return ComponentFactory.newForm(id, model);
    }

    protected Button newSubmitButton(String id) {
        return new Button(id){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                ReportThrowablePanel.this.onSubmitError();
            }
        };
    }

    protected abstract void onSubmitError();

    protected LabeledTextAreaPanel<ReportThrowableModel> newDescription(String id, IModel<ReportThrowableModel> model) {
        IModel labelModel = ResourceModelFactory.newResourceModel((String)"description.label", (Component)this, (String)"Please provide here any useful information");
        final IModel placeholderModel = ResourceModelFactory.newResourceModel((String)"global.enter.your.description.label", (Component)this, (String)"Enter here any useful information");
        LabeledTextAreaPanel<ReportThrowableModel> description = new LabeledTextAreaPanel<ReportThrowableModel>(id, model, labelModel){
            private static final long serialVersionUID = 1L;

            @Override
            protected TextArea<ReportThrowableModel> newTextArea(String id, IModel<ReportThrowableModel> model) {
                TextArea<ReportThrowableModel> textArea = super.newTextArea(id, model);
                if (placeholderModel != null) {
                    textArea.add(new Behavior[]{new AttributeAppender("placeholder", placeholderModel)});
                }
                return super.newTextArea(id, model);
            }
        };
        return description;
    }

    protected ReportThrowableModel newReportThrowableModel(Throwable throwable) {
        return ReportThrowableModel.builder().affectedUsername(this.newAffectedUsername()).responsePage(this.newResponsePageClass()).rootUsername(this.newRootUsername()).stackTrace(ExceptionUtils.getStackTraceElements((Throwable)throwable)).build();
    }

    protected abstract String newRootUsername();

    protected abstract Class<? extends IRequestablePage> newResponsePageClass();

    protected abstract String newAffectedUsername();

    public Label getHeader() {
        return this.header;
    }

    public Form<?> getForm() {
        return this.form;
    }

    public LabeledTextAreaPanel<ReportThrowableModel> getDescription() {
        return this.description;
    }

    public Button getSubmitButton() {
        return this.submitButton;
    }

    public Component getStackTrace() {
        return this.stackTrace;
    }

    private static class DisplayNoneBehavior
    extends AttributeModifier {
        private static final long serialVersionUID = 1L;

        private DisplayNoneBehavior() {
            super("style", (IModel)Model.of((Serializable)((Object)"display: none")));
        }

        public boolean isTemporary(Component component) {
            return true;
        }
    }

    private static class Effects {
        private Effects() {
        }

        private static void replace(AjaxRequestTarget target, Component component) {
            component.add(new Behavior[]{new DisplayNoneBehavior()});
            target.add(new Component[]{component});
            target.appendJavaScript((CharSequence)("jQuery('#" + component.getMarkupId() + "').slideDown(100);"));
        }
    }
}

