/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.radio;

import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.radio.AjaxRadio;
import de.alpharogroup.wicket.components.radio.RadioGroupModel;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketeer.modelfactory.ModelFactory;

public abstract class AjaxRadioPanel<T extends Serializable>
extends BasePanel<RadioGroupModel<T>> {
    private static final long serialVersionUID = 1L;
    private Form<?> form;
    private RadioGroup<T> radioGroup;

    protected abstract void onRadioSelect(AjaxRequestTarget var1, T var2);

    public AjaxRadioPanel(String id, IModel<RadioGroupModel<T>> model) {
        super(id, model);
        Component[] componentArray = new Component[1];
        this.form = this.newForm("form");
        componentArray[0] = this.form;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.radioGroup = this.newRadioGroup("radioGroup", ModelFactory.model(((RadioGroupModel)ModelFactory.from((Object)model.getObject())).getSelected()));
        componentArray2[0] = this.radioGroup;
        this.form.add(componentArray2);
        this.radioGroup.add(new Component[]{this.newRadios(this.radioGroup, model)});
    }

    protected Component newRadios(final RadioGroup<T> group, final IModel<RadioGroupModel<T>> model) {
        return new ListView<T>("radioButtons", ((RadioGroupModel)model.getObject()).getRadios()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<T> item) {
                AjaxRadio radio = AjaxRadioPanel.this.newAjaxRadio("radio", group, item);
                Label label = ComponentFactory.newLabel("label", radio.getMarkupId(), new PropertyModel((Object)item.getModel(), ((RadioGroupModel)model.getObject()).getLabelPropertyExpression()));
                item.add(new Component[]{radio});
                item.add(new Component[]{label});
            }
        };
    }

    protected AjaxRadio<T> newAjaxRadio(String id, final RadioGroup<T> group, ListItem<T> item) {
        return new AjaxRadio<T>("radio", item.getModel()){
            private static final long serialVersionUID = 1L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                AjaxRadioPanel.this.onRadioSelect(target, (Serializable)group.getModelObject());
            }
        };
    }

    protected Form<?> newForm(String id) {
        return ComponentFactory.newForm(id);
    }

    protected RadioGroup<T> newRadioGroup(String id, IModel<T> model) {
        return ComponentFactory.newRadioGroup(id, model);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(AjaxRadioPanel.class, "AjaxRadioPanel.js")));
    }

    public Form<?> getForm() {
        return this.form;
    }

    public RadioGroup<T> getRadioGroup() {
        return this.radioGroup;
    }
}

