/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.i18n.content;

import de.alpharogroup.locale.ResourceBundleKey;
import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.i18n.content.ContentModel;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class ContentPanel
extends BasePanel<ContentModel> {
    private static final long serialVersionUID = 1L;
    private final Component header;
    private final Component content;

    public ContentPanel(String id) {
        this(id, null);
    }

    public ContentPanel(String id, IModel<ContentModel> model) {
        super(id, model);
        this.setOutputMarkupId(true);
        if (model != null) {
            this.header = this.newHeaderLabel("header", (IModel<String>)ResourceModelFactory.newResourceModel((ResourceBundleKey)((ContentModel)model.getObject()).getHeaderResourceKey(), (Component)this));
            this.add(new Component[]{this.header});
            this.content = this.newContentLabel("content", (IModel<String>)ResourceModelFactory.newResourceModel((ResourceBundleKey)((ContentModel)model.getObject()).getContentResourceKey(), (Component)this));
            this.add(new Component[]{this.content});
        } else {
            this.header = this.newHeaderLabel("header", this.newHeaderModel());
            this.add(new Component[]{this.header});
            this.content = this.newContentLabel("content", this.newContentModel());
            this.add(new Component[]{this.content});
        }
    }

    protected Component newHeaderLabel(String id, IModel<String> model) {
        return ComponentFactory.newLabel(id, model);
    }

    protected IModel<String> newHeaderModel() {
        return ResourceModelFactory.newResourceModel((ResourceBundleKey)this.newHeaderResourceKey(), (Component)this);
    }

    protected ResourceBundleKey newHeaderResourceKey() {
        return ResourceBundleKey.builder().key("header.label").build();
    }

    protected Component newContentLabel(String id, IModel<String> model) {
        return ComponentFactory.newMultiLineLabel(id, model);
    }

    protected IModel<String> newContentModel() {
        return ResourceModelFactory.newResourceModel((ResourceBundleKey)this.newContentResourceKey(), (Component)this);
    }

    protected ResourceBundleKey newContentResourceKey() {
        return ResourceBundleKey.builder().key("content.label").build();
    }

    public Component getHeader() {
        return this.header;
    }

    public Component getContent() {
        return this.content;
    }
}

