/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.form;

import java.util.List;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

public abstract class ChoicesListView<T>
extends ListView<T> {
    private static final long serialVersionUID = 1L;
    private final IChoiceRenderer<T> choiceRenderer;

    public ChoicesListView(String id, IModel<List<T>> choices, IChoiceRenderer<T> renderer) {
        super(id, choices);
        this.choiceRenderer = renderer;
    }

    public IChoiceRenderer<T> getChoiceRenderer() {
        return this.choiceRenderer;
    }

    protected String getChoiceLabel(T choice) {
        Object displayValue = this.getChoiceRenderer().getDisplayValue(choice);
        Class<?> objectClass = displayValue == null ? null : displayValue.getClass();
        String label = "";
        if (objectClass != null && objectClass != String.class) {
            IConverter converter = this.getConverter(objectClass);
            label = converter.convertToString(displayValue, this.getLocale());
        } else if (displayValue != null) {
            label = displayValue.toString();
        }
        return label;
    }

    protected String getChoiceValue(T choice, int index) {
        return this.getChoiceRenderer().getIdValue(choice, index);
    }
}

