/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.download;

import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.base.util.application.ApplicationUtils;
import de.alpharogroup.wicket.behaviors.AjaxDownloadBehavior;
import de.alpharogroup.wicket.components.download.DownloadModel;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import java.io.IOException;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.IResourceStream;
import org.wicketeer.modelfactory.ModelFactory;

public abstract class DownloadPanel
extends BasePanel<DownloadModel> {
    private static final long serialVersionUID = 1L;
    private Component fileNameLabel;
    private AjaxLink<Void> downloadLink;

    public DownloadPanel(String id, IModel<DownloadModel> model) {
        super(id, model);
        Args.notNull(model, (String)"model");
    }

    protected void onInitialize() {
        super.onInitialize();
        this.fileNameLabel = this.newFileNameLabel("fileName", (IModel<String>)ModelFactory.model((Object)((DownloadModel)ModelFactory.from((Object)this.getModelObject())).getFilename()));
        this.downloadLink = this.newDownloadLink("downloadLink", (IModel<DownloadModel>)this.getModel());
        this.downloadLink.addOrReplace(new Component[]{this.fileNameLabel});
        this.addOrReplace(new Component[]{this.downloadLink});
    }

    protected abstract WebApplication getWebApplication();

    protected AjaxLink<Void> newDownloadLink(String id, final IModel<DownloadModel> model) {
        final AjaxDownloadBehavior download = new AjaxDownloadBehavior(){
            private static final long serialVersionUID = 1L;

            protected IResourceStream getResourceStream() {
                try {
                    return ApplicationUtils.getResourceStream((WebApplication)DownloadPanel.this.getWebApplication(), (String)((DownloadModel)model.getObject()).getPath(), (String)((DownloadModel)model.getObject()).getContentType());
                }
                catch (IOException e) {
                    DownloadPanel.this.getSession().info((Serializable)((Object)("Error: " + e.getLocalizedMessage())));
                    return null;
                }
            }

            protected String getFileName() {
                return ((DownloadModel)model.getObject()).getFilename();
            }
        };
        AjaxLink<Void> downloadLink = new AjaxLink<Void>("downloadLink"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                download.initiate(target);
            }
        };
        downloadLink.add(new Behavior[]{download});
        return downloadLink;
    }

    protected Component newFileNameLabel(String id, IModel<String> model) {
        return ComponentFactory.newLabel(id, model);
    }

    public Component getFileNameLabel() {
        return this.fileNameLabel;
    }

    public AjaxLink<Void> getDownloadLink() {
        return this.downloadLink;
    }
}

