/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.beaneditor;

import de.alpharogroup.wicket.components.factory.ComponentFactory;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxFallbackButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public abstract class BeanEditorPanel<T>
extends GenericPanel<T> {
    private static final long serialVersionUID = 1L;
    private final Form<?> form;
    private final Button button;
    private final RepeatingView fields;

    public BeanEditorPanel(String id, IModel<T> model) {
        super(id, model);
        Component[] componentArray = new Component[1];
        this.form = this.newForm("form", model);
        componentArray[0] = this.form;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.fields = this.newRepeatingView("fields", model);
        componentArray2[0] = this.fields;
        this.form.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.button = this.newSubmitButton("button", this.form);
        componentArray3[0] = this.button;
        this.form.add(componentArray3);
    }

    protected RepeatingView newRepeatingView(String id, IModel<T> model) {
        RepeatingView fields = new RepeatingView("fields");
        this.form.add(new Component[]{fields});
        Object modelObject = model.getObject();
        for (Field field : modelObject.getClass().getDeclaredFields()) {
            if (field.getName().equalsIgnoreCase("serialVersionUID")) continue;
            WebMarkupContainer row = new WebMarkupContainer(fields.newChildId());
            fields.add(new Component[]{row});
            Model labelModel = Model.of((Serializable)((Object)field.getName()));
            row.add(new Component[]{new Label("name", (IModel)labelModel)});
            PropertyModel fieldModel = new PropertyModel(modelObject, field.getName());
            row.add(new Component[]{this.newEditorForBeanField("editor", field, (IModel<?>)fieldModel)});
        }
        return fields;
    }

    protected Button newSubmitButton(String id, Form<?> form) {
        AjaxFallbackButton button = new AjaxFallbackButton(id, form){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                BeanEditorPanel.this.onSubmit(target, form);
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                BeanEditorPanel.this.onSubmit(target, form);
            }
        };
        return button;
    }

    protected Form<?> newForm(String id, IModel<?> model) {
        return ComponentFactory.newForm(id, model);
    }

    protected abstract Component newEditorForBeanField(String var1, Field var2, IModel<?> var3);

    protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
    }

    public Form<?> getForm() {
        return this.form;
    }

    public Button getButton() {
        return this.button;
    }

    public RepeatingView getFields() {
        return this.fields;
    }
}

