/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.swap;

import de.alpharogroup.wicket.components.swap.ModeContext;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public abstract class SwapFragmentPanel<T>
extends GenericPanel<T> {
    private static final long serialVersionUID = 1L;
    private Fragment view;
    private Fragment edit;
    private ModeContext modeContext = ModeContext.VIEW_MODE;
    private static final String FRAGMENT_ID = "fragment-placeholder";

    public SwapFragmentPanel(String id, IModel<T> model) {
        super(id, model);
        this.setModel((IModel)Args.notNull(model, (String)"model"));
        this.setDefaultModel((IModel)new CompoundPropertyModel(model));
        this.setOutputMarkupPlaceholderTag(true);
        Component[] componentArray = new Component[1];
        this.view = this.newViewFragment(FRAGMENT_ID);
        componentArray[0] = this.view;
        this.add(componentArray);
        this.edit = this.newEditFragment(FRAGMENT_ID);
    }

    private void swapFragments() {
        Fragment fragment = this.view;
        this.view.replaceWith((Component)this.edit);
        this.view = this.edit;
        this.edit = fragment;
    }

    protected abstract Fragment newViewFragment(String var1);

    protected abstract Fragment newEditFragment(String var1);

    protected void onSwapToEdit(AjaxRequestTarget target, Form<?> form) {
        this.swapFragments();
        target.add(new Component[]{this.view});
        this.modeContext = ModeContext.EDIT_MODE;
    }

    protected void onSwapToView(AjaxRequestTarget target, Form<?> form) {
        target.add(new Component[]{this.edit});
        this.swapFragments();
        this.modeContext = ModeContext.VIEW_MODE;
    }

    protected void swapFragments(AjaxRequestTarget target, Form<?> form) {
        if (this.modeContext.equals((Object)ModeContext.VIEW_MODE)) {
            this.onSwapToEdit(target, form);
        } else {
            this.onSwapToView(target, form);
        }
    }

    public Fragment getView() {
        return this.view;
    }

    public Fragment getEdit() {
        return this.edit;
    }

    public ModeContext getModeContext() {
        return this.modeContext;
    }
}

