/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.sign.up;

import de.alpharogroup.wicket.components.labeled.textfield.LabeledPasswordTextFieldPanel;
import de.alpharogroup.wicket.components.labeled.textfield.LabeledTextFieldPanel;
import de.alpharogroup.wicket.components.sign.in.SigninPanel;
import net.sourceforge.jaulp.auth.models.BaseUsernameSignUpModel;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.jaulp.wicket.base.util.resource.ResourceModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketeer.modelfactory.ModelFactory;

public class SignupPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(SignupPanel.class);
    private Component username;
    private Component signinPanel;
    private Component repeatPassword;

    public Component getSigninPanel() {
        return this.signinPanel;
    }

    public SignupPanel(String id, IModel<? extends BaseUsernameSignUpModel> model) {
        super(id, model);
        this.username = this.newUsernameTextField("username", model);
        this.add(new Component[]{this.username});
        this.signinPanel = this.newSigninPanel("signinPanel", model);
        this.add(new Component[]{this.signinPanel});
        this.repeatPassword = this.newRepeatPasswordTextField("repeatPassword", model);
        this.add(new Component[]{this.repeatPassword});
    }

    protected Component newSigninPanel(String id, IModel<? extends BaseUsernameSignUpModel> model) {
        return new SigninPanel(id, model);
    }

    protected Component newUsernameTextField(String id, final IModel<BaseUsernameSignUpModel> model) {
        IModel labelModel = ResourceModelFactory.newResourceModel((String)"global.username.label", (Component)this);
        final IModel placeholderModel = ResourceModelFactory.newResourceModel((String)"global.enter.your.username.label", (Component)this);
        LabeledTextFieldPanel<BaseUsernameSignUpModel> nameTextField = new LabeledTextFieldPanel<BaseUsernameSignUpModel>(id, model, labelModel){
            private static final long serialVersionUID = 1L;

            @Override
            protected TextField newTextField(String id, IModel<BaseUsernameSignUpModel> modelSuper) {
                TextField textField = new TextField(id, ModelFactory.model((Object)((BaseUsernameSignUpModel)ModelFactory.from((IModel)model)).getUsername()));
                textField.setOutputMarkupId(true);
                textField.setRequired(true);
                if (placeholderModel != null) {
                    textField.add(new Behavior[]{new AttributeAppender("placeholder", placeholderModel)});
                }
                return textField;
            }
        };
        return nameTextField;
    }

    protected Component newRepeatPasswordTextField(String id, final IModel<BaseUsernameSignUpModel> model) {
        IModel labelModel = ResourceModelFactory.newResourceModel((String)"global.repeat.password.label", (Component)this);
        final IModel placeholderModel = ResourceModelFactory.newResourceModel((String)"global.enter.your.password.again.label", (Component)this);
        LabeledPasswordTextFieldPanel<BaseUsernameSignUpModel> pwTextField = new LabeledPasswordTextFieldPanel<BaseUsernameSignUpModel>(id, model, labelModel){
            private static final long serialVersionUID = 1L;

            @Override
            protected PasswordTextField newPasswordTextField(String id, IModel<BaseUsernameSignUpModel> modelSuper) {
                PasswordTextField pwTextField = new PasswordTextField(id, ModelFactory.model((Object)((BaseUsernameSignUpModel)ModelFactory.from((IModel)model)).getRepeatPassword()));
                pwTextField.setOutputMarkupId(true);
                if (placeholderModel != null) {
                    pwTextField.add(new Behavior[]{new AttributeAppender("placeholder", placeholderModel)});
                }
                return pwTextField;
            }
        };
        return pwTextField;
    }

    public Component getUsername() {
        return this.username;
    }

    public Component getRepeatPassword() {
        return this.repeatPassword;
    }
}

