/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.sign.in;

import de.alpharogroup.wicket.components.labeled.textfield.LabeledEmailTextFieldPanel;
import de.alpharogroup.wicket.components.labeled.textfield.LabeledPasswordTextFieldPanel;
import net.sourceforge.jaulp.auth.models.SignInModel;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.EmailTextField;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.jaulp.wicket.base.util.resource.ResourceModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketeer.modelfactory.ModelFactory;

public class SigninPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(SigninPanel.class);
    private final Component email;
    private final Component password;

    public SigninPanel(String id, IModel<? extends SignInModel> model) {
        super(id, model);
        this.email = this.newEmailTextField("email", model);
        this.add(new Component[]{this.email});
        this.password = this.newPasswordTextField("password", model);
        this.add(new Component[]{this.password});
    }

    protected Component newEmailTextField(String id, final IModel<SignInModel> model) {
        IModel labelModel = ResourceModelFactory.newResourceModel((String)"global.email.label", (Component)this);
        final IModel placeholderModel = ResourceModelFactory.newResourceModel((String)"global.enter.your.email.label", (Component)this);
        LabeledEmailTextFieldPanel<SignInModel> emailTextField = new LabeledEmailTextFieldPanel<SignInModel>(id, model, labelModel){
            private static final long serialVersionUID = 1L;

            @Override
            protected EmailTextField newEmailTextField(String id, IModel<SignInModel> m) {
                EmailTextField emailTextField = new EmailTextField(id, (IModel)new PropertyModel(model.getObject(), "email"));
                emailTextField.setOutputMarkupId(true);
                emailTextField.setRequired(true);
                if (placeholderModel != null) {
                    emailTextField.add(new Behavior[]{new AttributeAppender("placeholder", placeholderModel)});
                }
                return emailTextField;
            }
        };
        return emailTextField;
    }

    protected Component newPasswordTextField(String id, IModel<SignInModel> model) {
        IModel labelModel = ResourceModelFactory.newResourceModel((String)"global.password.label", (Component)this);
        final IModel placeholderModel = ResourceModelFactory.newResourceModel((String)"global.enter.your.password.label", (Component)this);
        LabeledPasswordTextFieldPanel<SignInModel> pwTextField = new LabeledPasswordTextFieldPanel<SignInModel>(id, model, labelModel){
            private static final long serialVersionUID = 1L;

            @Override
            protected PasswordTextField newPasswordTextField(String id, IModel<SignInModel> model) {
                PasswordTextField pwTextField = new PasswordTextField(id, ModelFactory.model((Object)((SignInModel)ModelFactory.from(model)).getPassword()));
                pwTextField.setOutputMarkupId(true);
                if (placeholderModel != null) {
                    pwTextField.add(new Behavior[]{new AttributeAppender("placeholder", placeholderModel)});
                }
                return pwTextField;
            }
        };
        return pwTextField;
    }

    public Component getEmail() {
        return this.email;
    }

    public Component getPassword() {
        return this.password;
    }
}

