/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.radio;

import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.radio.RadioGroupModel;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.jaulp.wicket.base.BasePanel;

public abstract class RadioGroupPanel<T>
extends BasePanel<RadioGroupModel<T>> {
    private static final long serialVersionUID = 1L;

    public RadioGroupPanel(String id, IModel<RadioGroupModel<T>> model) {
        super(id, model);
        this.setOutputMarkupId(true);
        Form form = new Form("form");
        this.add(new Component[]{form});
        final RadioGroup group = new RadioGroup("group", (IModel)new PropertyModel(model.getObject(), "selected"));
        group.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                RadioGroupPanel.this.onUpdate(target);
            }
        }});
        group.setOutputMarkupId(true);
        form.add(new Component[]{group});
        group.add(new Component[]{new ListView<T>("choice", ((RadioGroupModel)model.getObject()).getRadios()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<T> item) {
                Radio radio = new Radio("radio", item.getModel(), group);
                radio.setOutputMarkupId(true);
                radio.add(new Behavior[]{new AttributeAppender("name", (Serializable)((Object)RadioGroupPanel.this.newRadioName()))});
                item.add(new Component[]{radio});
                item.add(new Component[]{RadioGroupPanel.this.newLabel("label", radio.getMarkupId(), item.getModel())});
            }
        }.setOutputMarkupId(true)});
    }

    protected Label newLabel(String id, String forId, IModel<T> model) {
        return ComponentFactory.newLabel(id, forId, model);
    }

    protected void onUpdate(AjaxRequestTarget target) {
        System.out.println("onupdate...");
    }

    protected String newRadioName() {
        return "radiogroup";
    }
}

