/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.menu.suckerfish;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public class MenuItem
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final AbstractLink link;
    private final Label label;
    private final List<MenuItem> subMenuItems = new ArrayList<MenuItem>();

    public MenuItem(AbstractLink link, String strLabel) {
        if (link != null && !link.getId().equals("linkid")) {
            throw new IllegalArgumentException("The id must be SuckerfishMenuPanel.LINK_ID");
        }
        this.link = link;
        this.label = new Label("linktext", strLabel);
        this.link.add(new Component[]{this.label});
    }

    public MenuItem(AbstractLink link, StringResourceModel strLabel) {
        if (link != null && !link.getId().equals("linkid")) {
            throw new IllegalArgumentException("The id must be SuckerfishMenuPanel.LINK_ID");
        }
        this.link = link;
        this.label = new Label("linktext", (IModel)strLabel);
        this.link.add(new Component[]{this.label});
    }

    public MenuItem(String strLabel) {
        this.link = null;
        this.label = new Label("linktext", strLabel);
    }

    public MenuItem(StringResourceModel stringResourceModel) {
        this.link = null;
        this.label = new Label("linktext", (IModel)stringResourceModel);
    }

    public void addMenu(MenuItem menu) {
        this.subMenuItems.add(menu);
    }

    public void setMenuItems(List<MenuItem> menuItems) {
        this.subMenuItems.clear();
        for (MenuItem child : menuItems) {
            this.addMenu(child);
        }
    }

    public AbstractLink getLink() {
        return this.link;
    }

    public List<MenuItem> getChildren() {
        return this.subMenuItems;
    }

    public Label getLabel() {
        return this.label;
    }
}

