/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.imprint;

import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.imprint.ImprintModel;
import de.alpharogroup.wicket.components.mailto.MailToPanel;
import de.alpharogroup.wicket.components.termofuse.disclaimer.DisclaimerPanel;
import net.sourceforge.jaulp.locale.ResourceBundleKey;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;
import org.jaulp.wicket.base.BasePanel;
import org.jaulp.wicket.base.util.resource.ResourceModelFactory;

public abstract class ImprintPanel
extends BasePanel<ImprintModel> {
    private static final long serialVersionUID = 1L;
    private final WebMarkupContainer disclaimerContainer;

    public WebMarkupContainer getDisclaimerContainer() {
        return this.disclaimerContainer;
    }

    public ImprintPanel(String id) {
        super(id);
        WebMarkupContainer imprintContainer = this.newImprintContainer("imprintContainer");
        this.add(new Component[]{imprintContainer});
        Object[] domainNameParams = new Object[]{this.getDomainName()};
        imprintContainer.add(new Component[]{new Label("imprintHeaderLbl", this.newImprintHeaderModel())});
        imprintContainer.add(new Component[]{new Label("urlWithSloganLbl", this.newSloganModel(domainNameParams))});
        imprintContainer.add(new Component[]{new Label("serviceFromLbl", this.newServiceFromModel())});
        imprintContainer.add(new Component[]{new Label("companyNameLbl", this.newCompanyNameModel())});
        imprintContainer.add(new Component[]{new Label("streetAndNumberLbl", this.newStreetAndNumberModel())});
        imprintContainer.add(new Component[]{new Label("zipAndCityLbl", this.newZipAndCityModel())});
        imprintContainer.add(new Component[]{new Label("state", this.newStateModel())});
        imprintContainer.add(new Component[]{new Label("authRepresentLabel", this.newAuthRepresentLabelModel())});
        imprintContainer.add(new Component[]{new Label("authRepresentContent", this.newAuthRepresentContentModel())});
        imprintContainer.add(new Component[]{new Label("companyRegisterEntryHeader", this.newCompanyRegisterEntryHeaderModel())});
        imprintContainer.add(new Component[]{new Label("companyRegisterEntryContent", this.newCompanyRegisterEntryContentModel())});
        imprintContainer.add(new Component[]{new Label("companyRegisterEntryNumber", this.newCompanyRegisterEntryNumberModel())});
        imprintContainer.add(new Component[]{new Label("companyRegisterIndedificationHeader", this.newCompanyRegisterIndedificationHeaderModel())});
        imprintContainer.add(new Component[]{new Label("companyRegisterIndedificationContent", this.newCompanyRegisterIndedificationContentModel())});
        imprintContainer.add(new Component[]{new Label("companyRegisterIndedificationNumber", this.newCompanyRegisterEntryNumberModel())});
        imprintContainer.add(new Component[]{new Label("companyEntryCommercialRegisterHeader", ResourceModelFactory.newResourceModel((ResourceBundleKey)ResourceBundleKey.builder().key("main.global.company.entry.commercial.register.header.label").defaultValue("").build(), (Component)this))});
        imprintContainer.add(new Component[]{new Label("companyEntryCommercialRegisterContent", ResourceModelFactory.newResourceModel((ResourceBundleKey)ResourceBundleKey.builder().key("main.global.company.entry.commercial.register.label").defaultValue("").build(), (Component)this))});
        imprintContainer.add(new Component[]{new Label("companyEntryCommercialRegisterNumber", ResourceModelFactory.newResourceModel((ResourceBundleKey)ResourceBundleKey.builder().key("main.global.company.entry.commercial.register.number").defaultValue("").build(), (Component)this))});
        this.disclaimerContainer = this.newDisclaimerContainer("disclaimerContainer");
        this.add(new Component[]{this.disclaimerContainer});
        this.disclaimerContainer.add(new Component[]{new DisclaimerPanel("disclaimerPanel")});
        this.disclaimerContainer.add(new Component[]{new MailToPanel("mailToPanel"){
            private static final long serialVersionUID = 1L;

            @Override
            protected String getDomainName() {
                return ImprintPanel.this.getDomainName();
            }
        }});
    }

    protected WebMarkupContainer newDisclaimerContainer(String id) {
        return ComponentFactory.newWebMarkupContainer(id);
    }

    protected WebMarkupContainer newImprintContainer(String id) {
        return ComponentFactory.newWebMarkupContainer(id);
    }

    protected abstract String getDomainName();

    protected IModel<String> newIModel(String key) {
        return new StringResourceModel(key, (Component)this, null, new Object[0]);
    }

    protected IModel<String> newServiceFromModel() {
        return this.newIModel("imprint.service.from.label");
    }

    protected IModel<String> newSloganModel(Object[] domainNameParams) {
        return new StringResourceModel("main.global.company.url.and.slogan.label", (Component)this, null, domainNameParams);
    }

    protected IModel<String> newImprintHeaderModel() {
        return this.newIModel("main.global.company.masthead.label");
    }

    protected IModel<String> newCompanyNameModel() {
        return this.newIModel("main.global.company.name.label");
    }

    protected IModel<String> newStreetAndNumberModel() {
        return this.newIModel("main.global.company.street.and.number.label");
    }

    protected IModel<String> newZipAndCityModel() {
        return this.newIModel("main.global.company.zipcode.and.city.label");
    }

    protected IModel<String> newStateModel() {
        return this.newIModel("main.global.company.state.label");
    }

    protected IModel<String> newAuthRepresentLabelModel() {
        return this.newIModel("main.global.company.authorised.representative.label");
    }

    protected IModel<String> newAuthRepresentContentModel() {
        return this.newIModel("main.global.company.authorised.representative");
    }

    protected IModel<String> newCompanyRegisterEntryHeaderModel() {
        return this.newIModel("main.global.company.register.entry.header.label");
    }

    protected IModel<String> newCompanyRegisterEntryContentModel() {
        return this.newIModel("main.global.company.register.entry.label");
    }

    protected IModel<String> newCompanyRegisterEntryNumberModel() {
        return this.newIModel("main.global.company.register.entry.court.number");
    }

    protected IModel<String> newCompanyRegisterIndedificationHeaderModel() {
        return this.newIModel("main.global.company.register.identification.header.label");
    }

    protected IModel<String> newCompanyRegisterIndedificationContentModel() {
        return this.newIModel("main.global.company.register.identification.label");
    }
}

