/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.editable.textfield;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class EditableTextField
extends Panel {
    private static final long serialVersionUID = 1L;
    private boolean editable;
    private final Label label;
    private final TextField<String> textField;

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public EditableTextField(String id, IModel<String> model) {
        super(id, model);
        this.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        this.editable = true;
        Component[] componentArray = new Component[1];
        this.label = this.newLabel("label", model);
        componentArray[0] = this.label;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.textField = this.newTextField("textField", model);
        componentArray2[0] = this.textField;
        this.add(componentArray2);
    }

    protected TextField<String> newTextField(String id, IModel<String> model) {
        TextField<String> textField = new TextField<String>(id, model){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                this.setVisibilityAllowed(EditableTextField.this.isEditable());
            }
        };
        textField.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        return textField;
    }

    protected Label newLabel(String id, IModel<String> model) {
        Label label = new Label(id, model){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                this.setVisibilityAllowed(!EditableTextField.this.isEditable());
            }
        };
        label.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
        return label;
    }

    public Label getLabel() {
        return this.label;
    }

    public TextField<String> getTextField() {
        return this.textField;
    }
}

