/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.download;

import de.alpharogroup.wicket.components.download.DownloadModel;
import java.io.IOException;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.IResourceStream;
import org.jaulp.wicket.base.BasePanel;
import org.jaulp.wicket.base.util.application.ApplicationUtils;
import org.jaulp.wicket.behaviors.AjaxDownloadBehavior;

public abstract class DownloadPanel
extends BasePanel<DownloadModel> {
    private static final long serialVersionUID = 1L;

    public DownloadPanel(String id, final IModel<DownloadModel> model) {
        super(id, model);
        Args.notNull(model, (String)"model");
        final AjaxDownloadBehavior download = new AjaxDownloadBehavior(){
            private static final long serialVersionUID = 1L;

            protected IResourceStream getResourceStream() {
                try {
                    return ApplicationUtils.getResourceStream((WebApplication)DownloadPanel.this.getWebApplication(), (String)((DownloadModel)model.getObject()).getPath(), (String)((DownloadModel)model.getObject()).getContentType());
                }
                catch (IOException e) {
                    DownloadPanel.this.getSession().info((Serializable)((Object)("Error: " + e.getLocalizedMessage())));
                    return null;
                }
            }

            protected String getFileName() {
                return ((DownloadModel)model.getObject()).getFilename();
            }
        };
        Label fileNameLabel = new Label("fileName", ((DownloadModel)model.getObject()).getFilename());
        AjaxLink<Void> downloadLink = new AjaxLink<Void>("pdfLink"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                download.initiate(target);
            }
        };
        downloadLink.add(new Behavior[]{download});
        downloadLink.add(new Component[]{fileNameLabel});
        this.addOrReplace(new Component[]{downloadLink});
    }

    protected abstract WebApplication getWebApplication();
}

