/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.deregistration;

import de.alpharogroup.wicket.components.deregistration.DeregistrationModel;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.i18n.content.ContentModel;
import de.alpharogroup.wicket.components.i18n.content.ContentPanel;
import de.alpharogroup.wicket.components.labeled.textarea.LabeledTextAreaPanel;
import java.io.Serializable;
import net.sourceforge.jaulp.collections.ListUtils;
import net.sourceforge.jaulp.locale.ResourceBundleKey;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.jaulp.wicket.base.BasePanel;
import org.jaulp.wicket.base.util.resource.ResourceModelFactory;
import org.jaulp.wicket.behaviors.AddJsQueryBehavior;

public abstract class DeregistrationPanel
extends BasePanel<DeregistrationModel> {
    private static final long serialVersionUID = 1L;
    private final Label buttonLabel;
    private final Button submitButton;
    private final Component motivation;
    private final Component contentPanel = this.newContentPanel("contentPanel");
    private final Form<?> form;

    public DeregistrationPanel(String id, IModel<DeregistrationModel> model) {
        super(id, model);
        this.add(new Component[]{this.contentPanel});
        Component[] componentArray = new Component[1];
        this.form = new Form("form", model);
        componentArray[0] = this.form;
        this.add(componentArray);
        this.motivation = this.newMotivation("motivation", model);
        this.form.add(new Component[]{this.motivation});
        this.submitButton = this.newButton("submitButton");
        Component[] componentArray2 = new Component[1];
        this.buttonLabel = this.newButtonLabel("buttonLabel", "sem.main.global.deregistration.user.label", "Deregister");
        componentArray2[0] = this.buttonLabel;
        this.submitButton.add(componentArray2);
        this.form.add(new Component[]{this.submitButton});
    }

    protected Component newContentPanel(String id) {
        ContentPanel contentPanel = new ContentPanel("contentPanel", (IModel<ContentModel>)Model.of((Serializable)ContentModel.builder().headerResourceKey(ResourceBundleKey.builder().key("sem.main.info.frame.deregistration.user.label").parameters(ListUtils.toObjectArray((Object[])new String[]{this.getDomainName()})).build()).contentResourceKey(ResourceBundleKey.builder().key("sem.main.info.frame.deregistration.user.label").parameters(ListUtils.toObjectArray((Object[])new String[]{this.getDomainName()})).build()).build()));
        contentPanel.getHeader().add(new Behavior[]{new AddJsQueryBehavior((CharSequence)"wrap", (CharSequence)"<h1></h1>")});
        contentPanel.getContent().add(new Behavior[]{new AddJsQueryBehavior((CharSequence)"wrap", (CharSequence)"<p class=\"lead\"></p>")});
        return contentPanel;
    }

    protected Label newLabel(String id, ResourceBundleKey resourceKey) {
        return ComponentFactory.newLabel(id, resourceKey, (Component)this);
    }

    protected LabeledTextAreaPanel<?> newMotivation(String id, IModel<DeregistrationModel> model) {
        IModel labelModel = ResourceModelFactory.newResourceModel((ResourceBundleKey)ResourceBundleKey.builder().key("sem.main.feedback.deregistration.user.label").defaultValue("Please confirm the deregistration").parameters(ListUtils.toObjectArray((Object[])new String[]{this.getDomainName()})).build(), (Component)this);
        final IModel placeholderModel = ResourceModelFactory.newResourceModel((String)"global.enter.your.deregistration.motivation.label", (Component)this, (String)"Enter here your deregistration motivation.");
        LabeledTextAreaPanel<DeregistrationModel> description = new LabeledTextAreaPanel<DeregistrationModel>(id, model, labelModel){
            private static final long serialVersionUID = 1L;

            @Override
            protected TextArea<DeregistrationModel> newTextArea(String id, PropertyModel<DeregistrationModel> model) {
                TextArea<DeregistrationModel> textArea = super.newTextArea(id, model);
                if (placeholderModel != null) {
                    textArea.add(new Behavior[]{new AttributeAppender("placeholder", placeholderModel)});
                }
                return super.newTextArea(id, model);
            }
        };
        return description;
    }

    protected Form<?> newForm(String id, IModel<?> model) {
        return ComponentFactory.newForm(id, model);
    }

    protected Button newButton(String id) {
        return new Button(id){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                DeregistrationPanel.this.onDeregistration();
            }
        };
    }

    protected Label newButtonLabel(String id, String resourceKey, String defaultValue) {
        return ComponentFactory.newLabel(id, ResourceModelFactory.newResourceModel((String)resourceKey, (Component)this, (String)defaultValue));
    }

    public Label getButtonLabel() {
        return this.buttonLabel;
    }

    public Button getSubmitButton() {
        return this.submitButton;
    }

    public Component getMotivation() {
        return this.motivation;
    }

    public Component getContentPanel() {
        return this.contentPanel;
    }

    public Form<?> getForm() {
        return this.form;
    }

    public abstract void onDeregistration();

    public abstract String getDomainName();
}

