/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.captcha.recaptcha;

import java.io.Serializable;
import net.sourceforge.jaulp.locale.ResourceBundleKey;
import net.tanesha.recaptcha.ReCaptcha;
import net.tanesha.recaptcha.ReCaptchaFactory;
import net.tanesha.recaptcha.ReCaptchaImpl;
import net.tanesha.recaptcha.ReCaptchaResponse;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.jaulp.wicket.base.util.ComponentFinder;
import org.jaulp.wicket.base.util.WicketComponentUtils;
import org.jaulp.wicket.base.util.parameter.PageParametersUtils;
import org.jaulp.wicket.base.util.resource.ResourceModelFactory;

public abstract class ReCaptchaPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String PARAMETER_KEY_RECAPTCHA_RESPONSE_FIELD = "recaptcha_response_field";
    private static final String PARAMETER_KEY_RECAPTCHA_CHALLENGE_FIELD = "recaptcha_challenge_field";
    private static final String RECAPTCHA_SERVER_URL = "https://www.google.com/recaptcha/api";

    public ReCaptchaPanel(String id) {
        super(id);
        this.add(new Component[]{new FormComponent<Serializable>("captcha", (IModel)new Model()){
            private static final long serialVersionUID = 1L;

            public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                this.replaceComponentTagBody(markupStream, openTag, ReCaptchaPanel.this.newReCaptcha(ReCaptchaPanel.this.getPublicKey(), ReCaptchaPanel.this.getPrivateKey(), false).createRecaptchaHtml("errorText", "clean", null));
            }

            public void validate() {
                String remoteAddress;
                ReCaptchaResponse reCaptchaResponse;
                ReCaptchaImpl reCaptcha = new ReCaptchaImpl();
                reCaptcha.setPrivateKey(ReCaptchaPanel.this.getPrivateKey());
                String challenge = PageParametersUtils.getParameter((String)ReCaptchaPanel.PARAMETER_KEY_RECAPTCHA_CHALLENGE_FIELD);
                String uresponse = PageParametersUtils.getParameter((String)ReCaptchaPanel.PARAMETER_KEY_RECAPTCHA_RESPONSE_FIELD);
                if (uresponse == null) {
                    uresponse = "";
                }
                if (!(reCaptchaResponse = reCaptcha.checkAnswer(remoteAddress = WicketComponentUtils.getHttpServletRequest().getRemoteAddr(), challenge, uresponse)).isValid()) {
                    this.error((Serializable)ResourceModelFactory.newResourceModel((ResourceBundleKey)ResourceBundleKey.builder().key("kaptcha.invalid.label").defaultValue("Incorrect answer, type the words from the image again!").build(), (Component)this).getObject());
                }
            }
        }});
    }

    private ReCaptcha newReCaptcha(String publicKey, String privateKey, boolean includeNoscript) {
        if (WicketComponentUtils.isSecure((Component)ComponentFinder.getCurrentPage())) {
            ReCaptcha reCaptcha = ReCaptchaFactory.newSecureReCaptcha((String)this.getPublicKey(), (String)this.getPrivateKey(), (boolean)includeNoscript);
            ((ReCaptchaImpl)reCaptcha).setRecaptchaServer(RECAPTCHA_SERVER_URL);
            return reCaptcha;
        }
        return ReCaptchaFactory.newReCaptcha((String)this.getPublicKey(), (String)this.getPrivateKey(), (boolean)includeNoscript);
    }

    public abstract String getPublicKey();

    public abstract String getPrivateKey();
}

