/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.behaviors.models;

import de.alpharogroup.wicket.base.util.ComponentFinder;
import java.io.Serializable;
import java.util.Objects;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;

public class ModelUpdateBehavior<T extends Serializable>
extends Behavior {
    private static final long serialVersionUID = 1L;
    private IModel<T> model;
    private T modelObject;

    public ModelUpdateBehavior(IModel<T> model) {
        this.model = (IModel)Args.notNull(model, (String)"model");
    }

    public void bind(Component component) {
        super.bind(component);
        component.setOutputMarkupPlaceholderTag(true);
    }

    public void onConfigure(Component component) {
        super.onConfigure(component);
        this.modelObject = (Serializable)this.model.getObject();
    }

    public void onEvent(Component component, IEvent<?> event) {
        super.onEvent(component, event);
        AjaxRequestTarget ajaxRequestTarget = ComponentFinder.findAjaxRequestTarget();
        Serializable currentModelObject = (Serializable)this.model.getObject();
        if (!Objects.equals(currentModelObject, this.modelObject)) {
            this.modelObject = currentModelObject;
            if (ajaxRequestTarget != null) {
                ajaxRequestTarget.add(new Component[]{component});
            }
        }
    }
}

