/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.behaviors;

import de.alpharogroup.wicket.base.util.url.WicketUrlExtensions;
import java.util.HashMap;
import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.TextTemplateResourceReference;
import org.apache.wicket.util.lang.Args;

public class JavascriptResourceReferenceAppenderBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final Class<? extends Page> pageClass;
    private final String filename;
    private final String id;

    public JavascriptResourceReferenceAppenderBehavior(Class<? extends Page> pageClass, String filename, String id) {
        Args.notNull(pageClass, (String)"pageClass");
        Args.notNull((Object)filename, (String)"filename");
        this.pageClass = pageClass;
        this.filename = filename;
        if (id == null) {
            id = String.valueOf(UUID.randomUUID());
        }
        this.id = id;
    }

    private ResourceReference getResourceReference() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", WicketUrlExtensions.getUrlAsString(this.pageClass));
        TextTemplateResourceReference resourceReference = new TextTemplateResourceReference(this.pageClass, this.filename, "text/javascript", Model.ofMap(map));
        return resourceReference;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)this.getResourceReference(), (String)this.id));
    }
}

