/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.behaviors;

import java.util.UUID;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.util.lang.Args;

public class JavascriptAppenderBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final CharSequence javascript;

    public JavascriptAppenderBehavior(CharSequence javascript) {
        this(String.valueOf(UUID.randomUUID()), javascript);
    }

    public JavascriptAppenderBehavior(String id, CharSequence javascript) {
        this.javascript = (CharSequence)Args.notNull((Object)javascript, (String)"javascript");
        this.id = id == null ? String.valueOf(UUID.randomUUID()) : id;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)this.javascript, (String)this.id));
    }

    public static JavascriptAppenderBehaviorBuilder builder() {
        return new JavascriptAppenderBehaviorBuilder();
    }

    public static class JavascriptAppenderBehaviorBuilder {
        private String id;
        private CharSequence javascript;

        JavascriptAppenderBehaviorBuilder() {
        }

        public JavascriptAppenderBehaviorBuilder id(String id) {
            this.id = id;
            return this;
        }

        public JavascriptAppenderBehaviorBuilder javascript(CharSequence javascript) {
            this.javascript = javascript;
            return this;
        }

        public JavascriptAppenderBehavior build() {
            return new JavascriptAppenderBehavior(this.id, this.javascript);
        }

        public String toString() {
            return "JavascriptAppenderBehavior.JavascriptAppenderBehaviorBuilder(id=" + this.id + ", javascript=" + this.javascript + ")";
        }
    }
}

