/*
 * Decompiled with CFR 0.152.
 */
package org.jaulp.wicket.base.util.url;

import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.https.Scheme;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.jaulp.wicket.base.util.WicketComponentUtils;

public class WicketUrlUtils {
    public static <C extends WebPage> String absoluteUrlFor(Class<C> page) {
        return WicketUrlUtils.absoluteUrlFor(page, null, false);
    }

    public static <C extends WebPage> String absoluteUrlFor(Class<C> page, boolean withServerPort) {
        return WicketUrlUtils.absoluteUrlFor(page, null, withServerPort);
    }

    public static <C extends WebPage> String absoluteUrlFor(Class<C> page, PageParameters parameters, boolean withServerPort) {
        StringBuilder url = new StringBuilder();
        url.append(WicketUrlUtils.getDomainUrl(withServerPort));
        url.append(WicketUrlUtils.getBaseUrl(page, parameters).canonical().toString());
        return url.toString();
    }

    public static Url getPageUrl(WebPage page) {
        return WicketUrlUtils.getPageUrl(page.getClass());
    }

    public static Url getPageUrl(WebPage page, PageParameters parameters) {
        return WicketUrlUtils.getPageUrl(page.getClass(), parameters);
    }

    public static Url getPageUrl(Class<? extends WebPage> pageClass) {
        return WicketUrlUtils.getPageUrl(pageClass, null);
    }

    public static Url getPageUrl(Class<? extends WebPage> pageClass, PageParameters parameters) {
        String url = RequestCycle.get().urlFor(pageClass, parameters).toString();
        return Url.parse((CharSequence)url);
    }

    public static Url getCanonicalPageUrl(Class<? extends WebPage> pageClass) {
        return WicketUrlUtils.getCanonicalPageUrl(pageClass, null);
    }

    public static Url getCanonicalPageUrl(Class<? extends WebPage> pageClass, PageParameters parameters) {
        return WicketUrlUtils.getPageUrl(pageClass, parameters).canonical();
    }

    public static Url getBaseUrl(WebPage page) {
        return WicketUrlUtils.getBaseUrl(page.getClass());
    }

    public static Url getBaseUrl(Class<? extends WebPage> pageClass) {
        return WicketUrlUtils.getBaseUrl(pageClass, null);
    }

    public static String toBaseUrl(Class<? extends WebPage> pageClass) {
        return WicketUrlUtils.getBaseUrl(pageClass).canonical().toString();
    }

    public static Url getBaseUrl(Class<? extends WebPage> pageClass, PageParameters parameters) {
        return RequestCycle.get().mapUrlFor(pageClass, parameters);
    }

    public static String toBaseUrl(Class<? extends WebPage> pageClass, PageParameters parameters) {
        return WicketUrlUtils.getBaseUrl(pageClass, parameters).canonical().toString();
    }

    public static Url getBaseUrl() {
        return RequestCycle.get().getUrlRenderer().getBaseUrl();
    }

    public static String toBaseUrl() {
        return WicketUrlUtils.getBaseUrl().canonical().toString();
    }

    public static String getContextPath(WebPage page) {
        return page.getRequest().getContextPath();
    }

    public static String getContextPath() {
        return RequestCycle.get().getRequest().getContextPath();
    }

    public static String getUrlAsString(WebPage page) {
        return WicketUrlUtils.getUrlAsString(page.getClass());
    }

    public static String getUrlAsString(Class<? extends WebPage> pageClass) {
        Url pageUrl = WicketUrlUtils.getPageUrl(pageClass);
        Url url = WicketUrlUtils.getBaseUrl(pageClass);
        url.resolveRelative(pageUrl);
        String contextPath = WicketUrlUtils.getContextPath();
        return String.format("%s/%s", contextPath, url);
    }

    public static String getLocalName() {
        return WicketComponentUtils.getHttpServletRequest().getLocalName();
    }

    public static String getServerName() {
        return WicketComponentUtils.getHttpServletRequest().getServerName();
    }

    public static String getDomainUrl() {
        return WicketUrlUtils.getDomainUrl(true);
    }

    public static String getDomainUrl(boolean withServerPort) {
        return WicketUrlUtils.getDomainUrl(withServerPort, true);
    }

    public static String getDomainUrl(boolean withServerPort, boolean withSlashAtTheEnd) {
        return WicketUrlUtils.getDomainUrl(false, withServerPort, withSlashAtTheEnd);
    }

    public static String getDomainUrl(boolean ssl, boolean withServerPort, boolean withSlashAtTheEnd) {
        return WicketUrlUtils.newDomainUrl(ssl ? Scheme.HTTPS.urlName() : Scheme.HTTP.urlName(), WicketUrlUtils.getServerName(), WicketComponentUtils.getHttpServletRequest().getServerPort(), withServerPort, withSlashAtTheEnd);
    }

    public static String newDomainUrl(String scheme, String domainName, int port, boolean withServerPort, boolean withSlashAtTheEnd) {
        StringBuilder domainUrl = new StringBuilder();
        domainUrl.append(scheme);
        domainUrl.append("://");
        domainUrl.append(domainName);
        if (withServerPort) {
            domainUrl.append(":");
            domainUrl.append(port);
        }
        if (withSlashAtTheEnd) {
            domainUrl.append("/");
        }
        return domainUrl.toString();
    }
}

