/*
 * Decompiled with CFR 0.152.
 */
package org.jaulp.wicket.base.util.parameter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.StringValueConversionException;

public final class PageParametersUtils {
    private static final Logger LOGGER = Logger.getLogger((String)PageParametersUtils.class.getName());

    public static String getParameter(PageParameters parameters, String name) {
        return PageParametersUtils.getString(parameters.get(name));
    }

    public static String getString(StringValue value) {
        if (PageParametersUtils.isNotNullOrEmpty(value)) {
            return value.toString();
        }
        return null;
    }

    public static Integer getInteger(StringValue stringValue) {
        return PageParametersUtils.toInteger(stringValue);
    }

    public static Integer toInteger(StringValue stringValue) {
        Integer value = null;
        if (PageParametersUtils.isNotNullOrEmpty(stringValue)) {
            try {
                value = stringValue.toInteger();
            }
            catch (StringValueConversionException e) {
                LOGGER.error((Object)"Error by converting the given StringValue.", (Throwable)e);
            }
        }
        return value;
    }

    public static final boolean isNotNullOrEmpty(StringValue stringValue) {
        return stringValue != null && !stringValue.isNull() && !stringValue.isEmpty();
    }

    public static final boolean isNullOrEmpty(StringValue stringValue) {
        return stringValue == null || stringValue.isNull() || stringValue.isEmpty();
    }

    public static PageParameters toPageParameters(Map<String, String> parameters) {
        PageParameters param = new PageParameters();
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            param.add(parameter.getKey(), (Object)parameter.getValue());
        }
        return param;
    }

    public static String getParameter(Request request, String parameterName) {
        String parameterValue = request.getRequestParameters().getParameterValue(parameterName).toString();
        if (parameterValue == null || parameterValue.isEmpty()) {
            parameterValue = request.getPostParameters().getParameterValue(parameterName).toString();
        }
        return parameterValue;
    }

    public static Map<String, String[]> getParameterMap() {
        Request request = RequestCycle.get().getRequest();
        return PageParametersUtils.getParameterMap(request);
    }

    public static Map<String, String[]> getParameterMap(Request request) {
        IRequestParameters parameters = request.getRequestParameters();
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Set parameterNames = parameters.getParameterNames();
        for (String parameterName : parameterNames) {
            List parameterValues = parameters.getParameterValues(parameterName);
            String[] stringArray = new String[]{};
            if (parameterValues != null && !parameterValues.isEmpty()) {
                stringArray = new String[parameterValues.size()];
                for (int i = 0; i < parameterValues.size(); ++i) {
                    stringArray[i] = ((StringValue)parameterValues.get(i)).toString();
                }
            }
            map.put(parameterName, stringArray);
        }
        return map;
    }

    public static String getParameter(String parameterName) {
        Request request = RequestCycle.get().getRequest();
        return PageParametersUtils.getParameter(request, parameterName);
    }
}

