/*
 * Decompiled with CFR 0.152.
 */
package org.jaulp.wicket.base.util;

import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.jaulp.lang.AnnotationUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.StringHeaderItem;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.https.RequireHttps;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.time.Time;
import org.jaulp.wicket.PackageResourceReferenceWrapper;
import org.jaulp.wicket.PackageResourceReferences;
import org.jaulp.wicket.base.enums.ResourceReferenceType;
import org.jaulp.wicket.base.util.parameter.PageParametersUtils;

public final class WicketComponentUtils {
    public static String getRequestURL() {
        StringBuffer url = WicketComponentUtils.getHttpServletRequest().getRequestURL();
        return url.toString();
    }

    public static HttpServletRequest getHttpServletRequest() {
        Request request = RequestCycle.get().getRequest();
        return WicketComponentUtils.getHttpServletRequest(request);
    }

    public static HttpServletRequest getHttpServletRequest(Request request) {
        WebRequest webRequest = (WebRequest)request;
        HttpServletRequest httpServletRequest = (HttpServletRequest)webRequest.getContainerRequest();
        return httpServletRequest;
    }

    public static HttpServletResponse getHttpServletResponse() {
        Response response = RequestCycle.get().getResponse();
        return WicketComponentUtils.getHttpServletResponse(response);
    }

    public static HttpServletResponse getHttpServletResponse(Response response) {
        WebResponse webResponse = (WebResponse)response;
        HttpServletResponse httpServletResponse = (HttpServletResponse)webResponse.getContainerResponse();
        return httpServletResponse;
    }

    public static String getParameter(Request request, String parameterName) {
        return PageParametersUtils.getParameter(request, parameterName);
    }

    public static Map<String, String[]> getParameterMap() {
        return PageParametersUtils.getParameterMap();
    }

    public static Map<String, String[]> getParameterMap(Request request) {
        return PageParametersUtils.getParameterMap(request);
    }

    public static PageParameters toPageParameters(Map<String, String> parameters) {
        return PageParametersUtils.toPageParameters(parameters);
    }

    public static String getParameter(String parameterName) {
        return PageParametersUtils.getParameter(parameterName);
    }

    public static String getIpAddress() {
        String ipAddress = WicketComponentUtils.getHttpServletRequest().getRemoteHost();
        return ipAddress;
    }

    public static String getRemoteAddr() {
        String ipAddress = WicketComponentUtils.getHttpServletRequest().getRemoteAddr();
        return ipAddress;
    }

    public static Behavior getHeaderContributorForFavicon() {
        return new Behavior(){
            private static final long serialVersionUID = 1L;

            public void renderHead(Component component, IHeaderResponse response) {
                response.render((HeaderItem)new StringHeaderItem((CharSequence)"<link type=\"image/x-icon\" rel=\"shortcut icon\" href=\"favicon.ico\" />"));
            }
        };
    }

    public static void disableCaching(WebResponse response) {
        response.setLastModifiedTime(Time.now());
        HttpServletResponse httpServletResponse = WicketComponentUtils.getHttpServletResponse((Response)response);
        if (httpServletResponse != null) {
            httpServletResponse.addHeader("Cache-Control", "max-age=0");
            httpServletResponse.setDateHeader("Expires", 0L);
        }
    }

    public static String toAbsolutePath(String relativePagePath) {
        HttpServletRequest req = (HttpServletRequest)((WebRequest)RequestCycle.get().getRequest()).getContainerRequest();
        return RequestUtils.toAbsolutePath((String)req.getRequestURL().toString(), (String)relativePagePath);
    }

    public static String getContextPath(WebApplication application) {
        String contextPath = application.getServletContext().getContextPath();
        if (null != contextPath && !contextPath.isEmpty()) {
            return contextPath;
        }
        return "";
    }

    public static void renderHeaderResponse(IHeaderResponse response, Class<?> componentClass) {
        Set headerContributors = PackageResourceReferences.getInstance().getPackageResourceReference(componentClass);
        if (null != headerContributors && !headerContributors.isEmpty()) {
            for (PackageResourceReferenceWrapper packageResourceReference : headerContributors) {
                JavaScriptReferenceHeaderItem headerItem;
                JavaScriptResourceReference reference;
                if (packageResourceReference.getType().equals((Object)ResourceReferenceType.JS) && !response.wasRendered((Object)(reference = new JavaScriptResourceReference(componentClass, packageResourceReference.getPackageResourceReference().getName())))) {
                    headerItem = JavaScriptHeaderItem.forReference((ResourceReference)reference);
                    response.render((HeaderItem)headerItem);
                }
                if (!packageResourceReference.getType().equals((Object)ResourceReferenceType.CSS) || response.wasRendered((Object)(reference = new CssResourceReference(componentClass, packageResourceReference.getPackageResourceReference().getName())))) continue;
                headerItem = CssHeaderItem.forReference((ResourceReference)reference);
                response.render((HeaderItem)headerItem);
            }
        }
    }

    public static boolean isSecure(Component component) {
        return AnnotationUtils.isAnnotationPresentInSuperClassesOrInterfaces(component.getClass(), RequireHttps.class);
    }

    public static boolean isHttps() {
        return WicketComponentUtils.getHttpServletRequest().getScheme().equalsIgnoreCase("https");
    }
}

