/*
 * Decompiled with CFR 0.152.
 */
package org.jaulp.wicket.base.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.protocol.http.RequestLogger;
import org.apache.wicket.protocol.http.WebApplication;
import org.jaulp.wicket.base.util.WicketComponentUtils;

public class SessionCountUtils {
    public static IRequestLogger getRequestLogger() {
        return SessionCountUtils.getRequestLogger(null);
    }

    public static IRequestLogger getRequestLogger(WebApplication webApplication) {
        IRequestLogger requestLogger;
        if (webApplication == null) {
            webApplication = (WebApplication)Application.get();
        }
        if ((requestLogger = webApplication.getRequestLogger()) == null) {
            requestLogger = new RequestLogger();
        }
        return requestLogger;
    }

    public static List<IRequestLogger.SessionData> getLiveSessions() {
        return new ArrayList<IRequestLogger.SessionData>(Arrays.asList(SessionCountUtils.getRequestLogger().getLiveSessions()));
    }

    public static Integer getPeakSessions() {
        return SessionCountUtils.getRequestLogger().getPeakSessions();
    }

    public static int getSessionTimeout() {
        HttpSession session;
        HttpServletRequest request = WicketComponentUtils.getHttpServletRequest();
        if (request != null && (session = request.getSession()) != null) {
            return session.getMaxInactiveInterval();
        }
        return -1;
    }

    public static HttpSession getHttpSession() {
        HttpSession session;
        HttpServletRequest request = WicketComponentUtils.getHttpServletRequest();
        if (request != null && (session = request.getSession()) != null) {
            return session;
        }
        return null;
    }
}

