/*
 * Decompiled with CFR 0.152.
 */
package org.jaulp.wicket.base.util;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;

public final class ComponentFinder {
    public static Page getCurrentPage() {
        IRequestHandler requestHandler = RequestCycle.get().getActiveRequestHandler();
        if (requestHandler instanceof IPageRequestHandler) {
            IPageRequestHandler pageRequestHandler = (IPageRequestHandler)requestHandler;
            return (Page)pageRequestHandler.getPage();
        }
        return null;
    }

    public static AjaxRequestTarget findAjaxRequestTarget() {
        return (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
    }

    public static AjaxRequestTarget newAjaxRequestTarget(WebApplication application, Page page) {
        return application.newAjaxRequestTarget(page);
    }

    public static Component findParent(Component childComponent, Class<? extends Component> parentClass) {
        MarkupContainer parent;
        for (parent = childComponent.getParent(); parent != null && !parent.getClass().equals(parentClass); parent = parent.getParent()) {
        }
        return parent;
    }
}

