/*
 * Decompiled with CFR 0.152.
 */
package org.jaulp.wicket.base.application;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class OnlineUsers<USER, ID>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<USER, ID> usersOnline = new HashMap<USER, ID>();
    private final Map<ID, USER> sessionIdToUser = new HashMap<ID, USER>();

    public synchronized ID addOnline(USER user, ID sessionId) {
        this.sessionIdToUser.put(sessionId, user);
        return this.usersOnline.put(user, sessionId);
    }

    public synchronized ID replaceSessionId(USER user, ID oldSessionId, ID newSessionId) {
        this.remove(oldSessionId);
        return this.addOnline(user, newSessionId);
    }

    public synchronized ID removeOnline(USER user) {
        ID sessionId = this.usersOnline.remove(user);
        if (sessionId != null) {
            this.sessionIdToUser.remove(sessionId);
        }
        return sessionId;
    }

    public synchronized USER remove(ID sessionId) {
        USER user = this.getUser(sessionId);
        if (user != null) {
            this.usersOnline.remove(user);
        }
        this.sessionIdToUser.remove(sessionId);
        return user;
    }

    public boolean isOnline(USER user) {
        return this.usersOnline.containsKey(user);
    }

    public ID getSessionId(USER user) {
        return this.usersOnline.get(user);
    }

    public USER getUser(ID sessionId) {
        return this.sessionIdToUser.get(sessionId);
    }

    public int getSize() {
        return this.usersOnline.size();
    }
}

