/*
 * Decompiled with CFR 0.152.
 */
package org.jaulp.wicket;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jaulp.io.annotations.ImportResource;
import net.sourceforge.jaulp.io.annotations.ImportResourcesUtils;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.jaulp.wicket.PackageResourceReferenceWrapper;
import org.jaulp.wicket.base.enums.ResourceReferenceType;

public class PackageResourceReferences {
    private static final PackageResourceReferences instance = new PackageResourceReferences();
    private final Map<Class<?>, Set<PackageResourceReferenceWrapper>> packageResourceReferenceMap = new LinkedHashMap();

    public static PackageResourceReferences getInstance() {
        return instance;
    }

    private PackageResourceReferences() {
    }

    public Map<Class<?>, Set<PackageResourceReferenceWrapper>> getPackageResourceReferenceMap() {
        return this.packageResourceReferenceMap;
    }

    private Set<PackageResourceReferenceWrapper> addPackageResourceReferenceFromInterfaces(Set<PackageResourceReferenceWrapper> packageResourceReferences, Class<?> searchClass) {
        Class<?>[] interfaces;
        for (Class<?> iface : interfaces = searchClass.getInterfaces()) {
            packageResourceReferences = this.addFoundPackageResourceReferences(packageResourceReferences, iface);
        }
        return packageResourceReferences;
    }

    private Set<PackageResourceReferenceWrapper> addFoundPackageResourceReferences(Set<PackageResourceReferenceWrapper> packageResourceReferences, Class<?> iface) {
        Set<PackageResourceReferenceWrapper> prr = PackageResourceReferences.getInstance().getPackageResourceReferenceMap().get(iface);
        if (packageResourceReferences != null && !packageResourceReferences.isEmpty()) {
            if (prr != null && !prr.isEmpty()) {
                packageResourceReferences.addAll(prr);
            }
        } else if (prr != null && !prr.isEmpty()) {
            packageResourceReferences = prr;
        }
        return packageResourceReferences;
    }

    public Set<PackageResourceReferenceWrapper> getPackageResourceReference(Class<?> componentClass) {
        Set<PackageResourceReferenceWrapper> packageResourceReference = PackageResourceReferences.getInstance().getPackageResourceReferenceMap().get(componentClass);
        packageResourceReference = this.addPackageResourceReferenceFromInterfaces(packageResourceReference, componentClass);
        return packageResourceReference;
    }

    public void initializeResources(String packageName) throws ClassNotFoundException, IOException {
        Map resourcesMap = ImportResourcesUtils.getImportResources((String)packageName);
        for (Map.Entry entry : resourcesMap.entrySet()) {
            Class key = (Class)entry.getKey();
            ImportResource[] value = (ImportResource[])entry.getValue();
            LinkedHashSet<PackageResourceReferenceWrapper> packageResourceReferences = new LinkedHashSet<PackageResourceReferenceWrapper>();
            for (ImportResource importResource : value) {
                PackageResourceReference t;
                if (importResource.resourceType().equalsIgnoreCase("js")) {
                    t = new PackageResourceReference(key, importResource.resourceName());
                    packageResourceReferences.add(new PackageResourceReferenceWrapper(t, ResourceReferenceType.JS));
                    continue;
                }
                if (!importResource.resourceType().equalsIgnoreCase("css")) continue;
                t = new PackageResourceReference(key, importResource.resourceName());
                packageResourceReferences.add(new PackageResourceReferenceWrapper(t, ResourceReferenceType.CSS));
            }
            PackageResourceReferences.getInstance().getPackageResourceReferenceMap().put(key, packageResourceReferences);
        }
    }
}

