/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.auth;

import de.alpharogroup.auth.interfaces.Session;
import de.alpharogroup.auth.interfaces.SessionContext;
import java.util.LinkedHashMap;
import java.util.Map;

public class UserSessionContext
implements SessionContext<String, String, String> {
    private static final long serialVersionUID = 6569927899638872741L;
    private Map<String, Session<String, String>> onlineSessions = new LinkedHashMap<String, Session<String, String>>();
    private static final SessionContext<String, String, String> instance = new UserSessionContext();

    public static SessionContext<String, String, String> getInstance() {
        return instance;
    }

    private UserSessionContext() {
    }

    @Override
    public synchronized void addSession(Session<String, String> session) {
        this.onlineSessions.put(session.getId(), session);
    }

    @Override
    public synchronized Session<String, String> getSession(String id) {
        if (this.onlineSessions.containsKey(id)) {
            return this.onlineSessions.get(id);
        }
        return null;
    }

    @Override
    public synchronized void removeSession(String id) {
        if (this.onlineSessions.containsKey(id)) {
            this.onlineSessions.remove(id);
        }
    }
}

