/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.auth.models;

/**
 * The Interface SimpleSignUpModel extends the SignInModel and adds the repeat pw of the member and
 * the term of use flag.
 */
public interface SimpleSignUpModel extends SignInModel
{

	/**
	 * Gets the repeat password.
	 * 
	 * @return the repeat password
	 */
	String getRepeatPassword();

	/**
	 * Sets the repeat password.
	 * 
	 * @param repeatPassword
	 *            the new repeat password
	 */
	void setRepeatPassword(String repeatPassword);

	/**
	 * Gets the term of use accepted.
	 * 
	 * @return the term of use accepted
	 */
	Boolean getTermOfUseAccepted();

	/**
	 * Sets the term of use accepted.
	 * 
	 * @param termOfUseAccepted
	 *            the new term of use accepted
	 */
	void setTermOfUseAccepted(Boolean termOfUseAccepted);

}