/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.auth.models;

/**
 * The Class BaseSignUpModel is an implementation from the interface SimpleSignUpModel.
 */
public class BaseSignUpModel extends BaseSignInModel implements SimpleSignUpModel
{

	/**
	 * The Constant serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;

	/** The repeatpassword. */
	private String repeatPassword;

	/** The term of use accepted. */
	private Boolean termOfUseAccepted = Boolean.TRUE;

	/**
	 * Instantiates a new base sign up model.
	 */
	public BaseSignUpModel()
	{
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getRepeatPassword()
	{
		return repeatPassword;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setRepeatPassword(String repeatPassword)
	{
		this.repeatPassword = repeatPassword;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Boolean getTermOfUseAccepted()
	{
		return termOfUseAccepted;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setTermOfUseAccepted(Boolean termOfUseAccepted)
	{
		this.termOfUseAccepted = termOfUseAccepted;
	}

}
