/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.auth.models;

/**
 * The Class BaseSignInModel is an implementation from the interface SignInModel.
 * 
 * @author Asterios Raptis
 */
public class BaseSignInModel implements SignInModel
{

	/**
	 * The serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;

	/** The Constant EMAIL. */
	public static final String EMAIL = "email";
	/** The Constant PASSWORD. */
	public static final String PASSWORD = "password";

	/** The email. */
	private String email;

	/** The password. */
	private String password;

	public BaseSignInModel()
	{
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getEmail()
	{
		return email;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getPassword()
	{
		return password;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setEmail(final String email)
	{
		this.email = email;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setPassword(final String password)
	{
		this.password = password;
	}

}
