/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.auth.interfaces;

import java.io.Serializable;

/**
 * The Interface SessionContext.
 *
 * @version 1.0
 *
 * @author Asterios Raptis
 *
 * @param <K>
 *            The Type for the Key.
 * @param <SK>
 *            the type of keys maintained by the session attribute map
 * @param <SV>
 *            the type of mapped values *
 */
public interface SessionContext<K, SK, SV> extends Serializable
{

	/**
	 * Adds the session to the context.
	 *
	 * @param session
	 *            the session
	 */
	void addSession(final Session<SK, SV> session);

	/**
	 * Gets the session from the given id.
	 *
	 * @param id
	 *            the id
	 * @return the session
	 */
	Session<SK, SV> getSession(final K id);

	/**
	 * Removes the session from the context.
	 *
	 * @param id
	 *            the id from the session to be removed.
	 */
	void removeSession(final K id);

}