/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.auth.interfaces;

import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

/**
 * The Interface Session.
 *
 * @version 1.0
 *
 * @author Asterios Raptis
 * 
 * @param <K>
 *            the type of keys maintained by the attribute map
 * @param <V>
 *            the type of mapped values *
 *
 */
public interface Session<K, V> extends Serializable
{

	/**
	 * Returns the field <code>id</code>.
	 *
	 * @return The field <code>id</code>.
	 */
	String getId();

	/**
	 * Sets the field <code>id</code>.
	 *
	 * @param id
	 *            The <code>id</code> to set
	 */
	void setId(String id);

	/**
	 * Returns the field <code>locale</code>.
	 *
	 * @return The field <code>locale</code>.
	 */
	Locale getLocale();

	/**
	 * Sets the field <code>locale</code>.
	 *
	 * @param locale
	 *            The <code>locale</code> to set
	 */
	void setLocale(Locale locale);

	/**
	 * Returns the field <code>startTime</code>.
	 *
	 * @return The field <code>startTime</code>.
	 */
	Date getStartTime();

	/**
	 * Sets the field <code>startTime</code>.
	 *
	 * @param startTime
	 *            The <code>startTime</code> to set
	 */
	void setStartTime(Date startTime);

	/**
	 * Returns the field <code>user</code>.
	 *
	 * @return The field <code>user</code>.
	 */
	User<Permission, Role<Permission>> getUser();

	/**
	 * Sets the field <code>user</code>.
	 *
	 * @param user
	 *            The <code>user</code> to set.
	 */
	void setUser(User<Permission, Role<Permission>> user);

	/**
	 * Returns the field <code>lastAccess</code>.
	 *
	 * @return The field <code>lastAccess</code>.
	 */
	Date getLastAccess();

	/**
	 * Sets the field <code>lastAccess</code>.
	 *
	 * @param lastAccess
	 *            The <code>lastAccess</code> to set
	 */
	void setLastAccess(Date lastAccess);

	/**
	 * Returns the field <code>maxInactiveTime</code>.
	 *
	 * @return The field <code>maxInactiveTime</code>.
	 */
	int getMaxInactiveTime();

	/**
	 * Sets the field <code>maxInactiveTime</code>.
	 *
	 * @param maxInactiveTime
	 *            The <code>maxInactiveTime</code> to set
	 */
	void setMaxInactiveTime(int maxInactiveTime);

	/**
	 * Returns the field <code>attributtes</code>.
	 *
	 * @return The field <code>attributtes</code>.
	 */
	Map<K, V> getAttributtes();

	V getAttributte(K key);

	V setAttribute(K key, V value);

	/**
	 * Sets the field <code>attributtes</code>.
	 *
	 * @param attributtes
	 *            The <code>attributtes</code> to set
	 */
	void setAttributtes(Map<K, V> attributtes);

}