/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.auth.interfaces;

import java.io.Serializable;

/**
 * The Interface Permission.
 * 
 * @version 1.0
 * @author Asterios Raptis
 */
public interface Permission extends Serializable
{

	/**
	 * Returns the field <code>description</code>.
	 * 
	 * @return The field <code>description</code>.
	 */
	public String getDescription();

	/**
	 * Sets the field <code>description</code>.
	 * 
	 * @param description
	 *            The <code>description</code> to set
	 */
	public void setDescription(String description);

	/**
	 * Returns the field <code>name</code>.
	 * 
	 * @return The field <code>name</code>.
	 */
	public String getPermissionName();

	/**
	 * Sets the field <code>name</code>.
	 * 
	 * @param name
	 *            The <code>name</code> to set
	 */
	public void setPermissionName(String name);

	String getShortcut();

	void setShortcut(final String shortcut);

}