/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.auth;

import java.util.LinkedHashMap;
import java.util.Map;

import de.alpharogroup.auth.interfaces.Session;
import de.alpharogroup.auth.interfaces.SessionContext;

/**
 * The Class UserSessionContext. Singleton object.
 *
 * @version 1.0
 * @author Asterios Raptis
 */
public class UserSessionContext implements SessionContext<String, String, String>
{

	/**
	 * The serialVersionUID.
	 */
	private static final long serialVersionUID = 6569927899638872741L;

	/**
	 * Returns the field <code>instance</code>.
	 *
	 * @return The field <code>instance</code>.
	 */
	public static SessionContext<String, String, String> getInstance()
	{

		return instance;
	}

	/** The online sessions. */
	private Map<String, Session<String, String>> onlineSessions = new LinkedHashMap<>();

	/** The instance. */
	private static final SessionContext<String, String, String> instance = new UserSessionContext();

	/**
	 * Instantiates a new user session context. It private.
	 */
	private UserSessionContext()
	{
		super();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.alpharogroup.auth.interfaces.SessionContext#addSession(de.alpharogroup.auth.interfaces.Session)
	 */
	@Override
	public synchronized void addSession(final Session<String, String> session)
	{
		this.onlineSessions.put(session.getId(), session);
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.alpharogroup.auth.interfaces.SessionContext#getSession(Object)
	 */
	@Override
	public synchronized Session<String, String> getSession(final String id)
	{
		if (this.onlineSessions.containsKey(id))
		{
			return this.onlineSessions.get(id);
		}
		return null;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see de.alpharogroup.auth.interfaces.SessionContext#removeSession(Object)
	 */
	@Override
	public synchronized void removeSession(final String id)
	{
		if (this.onlineSessions.containsKey(id))
		{
			this.onlineSessions.remove(id);
		}
	}

}
