/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.auth;

import java.util.HashSet;
import java.util.Set;

import de.alpharogroup.auth.interfaces.Permission;
import de.alpharogroup.auth.interfaces.Role;
import de.alpharogroup.auth.interfaces.User;

/**
 * The Class SimpleUser.
 *
 * @version 1.0
 * @author Asterios Raptis
 */
public class SimpleUser implements User<Permission, Role<Permission>>
{

	/**
	 * The serialVersionUID.
	 */
	private static final long serialVersionUID = 8255560614886684003L;
	/** The attribute active, if true the user account is active. */
	private Boolean active;
	/** The username. */
	private String username;

	/** The username. */
	private String pw;

	/** The id. */
	private String id;

	/** The roles. */
	private Set<Role<Permission>> roles = new HashSet<>();

	/** Flag if the user is locked. */
	private Boolean locked;

	/**
	 * {@inheritDoc}
	 *
	 * @see de.alpharogroup.auth.interfaces.User#getId()
	 */
	@Override
	public String getId()
	{
		return this.id;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see de.alpharogroup.auth.interfaces.User#getUsername()
	 */
	@Override
	public String getUsername()
	{
		return this.username;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see de.alpharogroup.auth.interfaces.User#isLocked()
	 */
	@Override
	public Boolean isLocked()
	{
		return this.locked;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see de.alpharogroup.auth.interfaces.User#setId(java.lang.String)
	 */
	@Override
	public void setId(final String id)
	{
		this.id = id;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setLocked(final Boolean lock)
	{
		this.locked = lock;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see de.alpharogroup.auth.interfaces.User#setUsername(java.lang.String)
	 */
	@Override
	public void setUsername(final String username)
	{
		this.username = username;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see de.alpharogroup.auth.interfaces.User#getPw()
	 */
	@Override
	public String getPw()
	{
		return this.pw;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setPw(String password)
	{
		this.pw = password;
	}

	@Override
	public Boolean isActive()
	{
		return this.active;
	}

	@Override
	public void setActive(Boolean active)
	{
		this.active = active;
	}

	@Override
	public void addRole(Role<Permission> role)
	{
		this.roles.add(role);
	}

	@Override
	public Set<Role<Permission>> getRoles()
	{
		return this.roles;
	}

	@Override
	public boolean removeRole(Role<Permission> role)
	{
		return this.roles.remove(role);
	}

	@Override
	public void setRoles(Set<Role<Permission>> roles)
	{
		this.roles = roles;
	}

}
