/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.auth;

import java.util.Set;

import de.alpharogroup.auth.interfaces.Permission;
import de.alpharogroup.auth.interfaces.Role;

/**
 * The Class SimpleRole.
 *
 * @version 1.0
 * @author Asterios Raptis
 */
public class SimpleRole implements Role<Permission>
{

	/**
	 * The serialVersionUID.
	 */
	private static final long serialVersionUID = -5456020518185764323L;

	/** The name. */
	private String name;

	/** The permissions. */
	private Set<Permission> permissions;

	/** The description from the role. */
	private String description;

	/**
	 * {@inheritDoc}
	 *
	 * @see de.alpharogroup.auth.interfaces.Role#getPermissions()
	 */
	@Override
	public Set<Permission> getPermissions()
	{
		return this.permissions;
	}

	/**
	 * Returns the field <code>description</code>.
	 *
	 * @return The field <code>description</code>.
	 */
	@Override
	public String getDescription()
	{
		return this.description;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @see de.alpharogroup.auth.interfaces.Role#getRolename()
	 */
	@Override
	public String getRolename()
	{
		return this.name;
	}


	/**
	 * Sets the field <code>description</code>.
	 *
	 * @param description
	 *            The <code>description</code> to set
	 */
	@Override
	public void setDescription(final String description)
	{
		this.description = description;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setRolename(final String name)
	{
		this.name = name;
	}

	@Override
	public void setPermissions(Set<Permission> permissions)
	{
		this.permissions = permissions;
	}

}
