/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.auth;

import de.alpharogroup.auth.interfaces.Permission;

/**
 * The Class SimpleAccessRight.
 *
 * @version 1.0
 * @author Asterios Raptis
 */
public class SimplePermission implements Permission
{

	/**
	 * The serialVersionUID.
	 */
	private static final long serialVersionUID = -1128896772349172908L;

	/** The name. */
	private String name;

	/** The description. */
	private String description;

	/**
	 * {@inheritDoc}
	 *
	 * @return the description
	 * @see de.alpharogroup.auth.interfaces.Permission#getDescription()
	 */
	@Override
	public String getDescription()
	{
		return this.description;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @return the name
	 * @see de.alpharogroup.auth.interfaces.Permission#getPermissionName()
	 */
	@Override
	public String getPermissionName()
	{
		return this.name;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @param description
	 *            the description
	 * @see de.alpharogroup.auth.interfaces.Permission#setDescription(java.lang.String)
	 */
	@Override
	public void setDescription(final String description)
	{
		this.description = description;
	}

	/**
	 * {@inheritDoc}
	 *
	 * @param name
	 *            the name
	 * @see de.alpharogroup.auth.interfaces.Permission#setPermissionName(java.lang.String)
	 */
	@Override
	public void setPermissionName(final String name)
	{
		this.name = name;
	}

	@Override
	public String getShortcut()
	{
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void setShortcut(String shortcut)
	{
		// TODO Auto-generated method stub

	}

}
