/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.auth.models;

/**
 * The enum ValidationErrors holds error constants that can occur over the sign up or sign in
 * process.
 */
public enum ValidationErrors
{
	/** Indicates that the term of use are not accepted. */
	TERM_OF_USE_ERROR,
	/** Indicates that the email already exists. */
	EMAIL_EXISTS_ERROR,
	/** Indicates that the username already exists. */
	USERNAME_EXISTS_ERROR,
	/** Indicates that the passwords are uneqaul. */
	UNEQAUL_PASSWORDS_ERROR
};