/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.auth.models;

/**
 * The Class BaseUsernameSignUpModel is an implementation from the interface UsernameSignUpModel.
 */
public class BaseUsernameSignUpModel extends BaseSignUpModel implements UsernameSignUpModel
{

	/**
	 * The Constant serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;

	/** The username. */
	private String username;

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getUsername()
	{
		return username;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setUsername(String username)
	{
		this.username = username;
	}

}
