/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.auth.interfaces;

import java.io.Serializable;
import java.util.Set;

/**
 * The Interface User.
 *
 * @param <P>
 *            the generic type
 * @param <R>
 *            the generic type
 * @version 1.1
 * @author Asterios Raptis
 */
public interface User<P extends Permission, R extends Role<P>> extends Serializable
{

	/**
	 * Adds the given role to the user.
	 *
	 * @param role
	 *            the role
	 */
	public void addRole(R role);

	/**
	 * Returns the field <code>id</code>.
	 *
	 * @return The field <code>id</code>.
	 */
	public String getId();

	/**
	 * Returns the field <code>roles</code>.
	 *
	 * @return The field <code>roles</code>.
	 */
	public Set<R> getRoles();

	/**
	 * Returns the field <code>username</code>.
	 *
	 * @return The field <code>username</code>.
	 */
	public String getUsername();

	/**
	 * Returns the field <code>password</code>.
	 *
	 * @return The field <code>password</code>.
	 */
	public String getPw();

	/**
	 * Returns the field <code>lock</code>.
	 *
	 * @return The field <code>lock</code>.
	 */
	public Boolean isLocked();

	/**
	 * Checks if this User is active.
	 *
	 * @return true if the User is active otherwise false.
	 */
	Boolean isActive();

	/**
	 * Sets the active flag.
	 *
	 * @param active
	 *            the new active flag.
	 */
	void setActive(final Boolean active);

	/**
	 * Removes the given role from the user.
	 *
	 * @param role
	 *            the role
	 * @return true, if successful
	 */
	public boolean removeRole(R role);

	/**
	 * Sets the field <code>id</code>.
	 *
	 * @param id
	 *            The <code>id</code> to set
	 */
	public void setId(String id);

	/**
	 * Sets the field <code>lock</code>.
	 *
	 * @param locked
	 *            The <code>lock</code> to set
	 */
	public void setLocked(Boolean locked);

	/**
	 * Sets the field <code>roles</code>.
	 *
	 * @param roles
	 *            The <code>roles</code> to set
	 */
	public void setRoles(Set<R> roles);

	/**
	 * Sets the field <code>username</code>.
	 *
	 * @param username
	 *            The <code>username</code> to set
	 */
	public void setUsername(String username);

	/**
	 * Sets the field <code>password</code>.
	 *
	 * @param password
	 *            The <code>password</code> to set
	 */
	public void setPw(String password);

}