/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.auth.interfaces;

import java.io.Serializable;
import java.util.Set;

/**
 * The Interface Role.
 * 
 * @version 1.0
 * @author Asterios Raptis
 * @param <T>
 *            the generic type
 */
public interface Role<T extends Permission> extends Serializable
{

	/**
	 * Returns the field <code>description</code>.
	 * 
	 * @return The field <code>description</code>.
	 */
	String getDescription();

	/**
	 * Sets the field <code>description</code>.
	 * 
	 * @param description
	 *            The <code>description</code> to set
	 */
	void setDescription(String description);

	/**
	 * Gets the name.
	 * 
	 * @return the name.
	 */
	String getRolename();

	/**
	 * Sets the name.
	 * 
	 * @param name
	 *            the new name.
	 */
	void setRolename(String name);

	/**
	 * Gets the access rights.
	 * 
	 * @return the permissions
	 */
	Set<T> getPermissions();

	/**
	 * Sets the permissions.
	 * 
	 * @param permissions
	 *            the new access rights.
	 */
	public void setPermissions(Set<T> permissions);

}