/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.auth.exceptions;

/**
 * Thrown when user already exists.
 * 
 * @version 1.0
 * @author Asterios Raptis
 */
public class UserAlreadyExistsException extends Exception
{

	/**
	 * The serialVersionUID.
	 */
	private static final long serialVersionUID = 2356585373552397779L;

	/**
	 * Instantiates a new user already exists exception.
	 */
	public UserAlreadyExistsException()
	{
		super();
	}

	/**
	 * Instantiates a new user already exists exception.
	 * 
	 * @param string
	 *            the string
	 */
	public UserAlreadyExistsException(final String string)
	{
		super(string);
	}

	/**
	 * Instantiates a new user already exists exception.
	 * 
	 * @param message
	 *            the message
	 * @param cause
	 *            the cause
	 */
	public UserAlreadyExistsException(final String message, final Throwable cause)
	{
		super(message, cause);
	}

	/**
	 * Instantiates a new user already exists exception.
	 * 
	 * @param cause
	 *            the cause
	 */
	public UserAlreadyExistsException(final Throwable cause)
	{
		super(cause);
	}

}
