/**
 * Copyright (C) 2007 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sourceforge.jaulp.auth.enums;

/**
 * The Enum InsertUserState keeps three states for checking if the user exist or not.
 */
public enum InsertUserState
{

	/** The flag that indicates that the email exists. */
	EMAIL_EXISTS,
	/** The flag that indicates that the username exists. */
	USERNAME_EXISTS,
	/** The insert flag indicates that the user can be inserted into the database. */
	INSERT;
}